@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin

import com.pulumi.aws.appstream.DirectoryConfigArgs.builder
import com.pulumi.aws.appstream.kotlin.inputs.DirectoryConfigServiceAccountCredentialsArgs
import com.pulumi.aws.appstream.kotlin.inputs.DirectoryConfigServiceAccountCredentialsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an AppStream Directory Config.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appstream.DirectoryConfig;
 * import com.pulumi.aws.appstream.DirectoryConfigArgs;
 * import com.pulumi.aws.appstream.inputs.DirectoryConfigServiceAccountCredentialsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DirectoryConfig("example", DirectoryConfigArgs.builder()
 *             .directoryName("NAME OF DIRECTORY")
 *             .organizationalUnitDistinguishedNames("DISTINGUISHED NAME")
 *             .serviceAccountCredentials(DirectoryConfigServiceAccountCredentialsArgs.builder()
 *                 .accountName("NAME OF ACCOUNT")
 *                 .accountPassword("PASSWORD OF ACCOUNT")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_appstream_directory_config` using the id. For example:
 * ```sh
 *  $ pulumi import aws:appstream/directoryConfig:DirectoryConfig example directoryNameExample
 * ```
 * @property directoryName Fully qualified name of the directory.
 * @property organizationalUnitDistinguishedNames Distinguished names of the organizational units for computer accounts.
 * @property serviceAccountCredentials Configuration block for the name of the directory and organizational unit (OU) to use to join the directory config to a Microsoft Active Directory domain. See `service_account_credentials` below.
 */
public data class DirectoryConfigArgs(
    public val directoryName: Output<String>? = null,
    public val organizationalUnitDistinguishedNames: Output<List<String>>? = null,
    public val serviceAccountCredentials: Output<DirectoryConfigServiceAccountCredentialsArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.appstream.DirectoryConfigArgs> {
    override fun toJava(): com.pulumi.aws.appstream.DirectoryConfigArgs =
        com.pulumi.aws.appstream.DirectoryConfigArgs.builder()
            .directoryName(directoryName?.applyValue({ args0 -> args0 }))
            .organizationalUnitDistinguishedNames(
                organizationalUnitDistinguishedNames?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .serviceAccountCredentials(
                serviceAccountCredentials?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DirectoryConfigArgs].
 */
@PulumiTagMarker
public class DirectoryConfigArgsBuilder internal constructor() {
    private var directoryName: Output<String>? = null

    private var organizationalUnitDistinguishedNames: Output<List<String>>? = null

    private var serviceAccountCredentials: Output<DirectoryConfigServiceAccountCredentialsArgs>? =
        null

    /**
     * @param value Fully qualified name of the directory.
     */
    @JvmName("cykakhnitxvnoidi")
    public suspend fun directoryName(`value`: Output<String>) {
        this.directoryName = value
    }

    /**
     * @param value Distinguished names of the organizational units for computer accounts.
     */
    @JvmName("lkxrysgwermqlcah")
    public suspend fun organizationalUnitDistinguishedNames(`value`: Output<List<String>>) {
        this.organizationalUnitDistinguishedNames = value
    }

    @JvmName("tsamvdfrysmwahks")
    public suspend fun organizationalUnitDistinguishedNames(vararg values: Output<String>) {
        this.organizationalUnitDistinguishedNames = Output.all(values.asList())
    }

    /**
     * @param values Distinguished names of the organizational units for computer accounts.
     */
    @JvmName("xxmtvddfqwmdbvku")
    public suspend fun organizationalUnitDistinguishedNames(values: List<Output<String>>) {
        this.organizationalUnitDistinguishedNames = Output.all(values)
    }

    /**
     * @param value Configuration block for the name of the directory and organizational unit (OU) to use to join the directory config to a Microsoft Active Directory domain. See `service_account_credentials` below.
     */
    @JvmName("rlxgjwakdkjhvdaw")
    public suspend
    fun serviceAccountCredentials(`value`: Output<DirectoryConfigServiceAccountCredentialsArgs>) {
        this.serviceAccountCredentials = value
    }

    /**
     * @param value Fully qualified name of the directory.
     */
    @JvmName("iyrxftsvbcopepth")
    public suspend fun directoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryName = mapped
    }

    /**
     * @param value Distinguished names of the organizational units for computer accounts.
     */
    @JvmName("sxbdmlmhpiuaxsuq")
    public suspend fun organizationalUnitDistinguishedNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationalUnitDistinguishedNames = mapped
    }

    /**
     * @param values Distinguished names of the organizational units for computer accounts.
     */
    @JvmName("fqxcpfhklypakjeg")
    public suspend fun organizationalUnitDistinguishedNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.organizationalUnitDistinguishedNames = mapped
    }

    /**
     * @param value Configuration block for the name of the directory and organizational unit (OU) to use to join the directory config to a Microsoft Active Directory domain. See `service_account_credentials` below.
     */
    @JvmName("evwlhvfhebpaopqp")
    public suspend
    fun serviceAccountCredentials(`value`: DirectoryConfigServiceAccountCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceAccountCredentials = mapped
    }

    /**
     * @param argument Configuration block for the name of the directory and organizational unit (OU) to use to join the directory config to a Microsoft Active Directory domain. See `service_account_credentials` below.
     */
    @JvmName("kftdehcqgkkxyfuj")
    public suspend
    fun serviceAccountCredentials(argument: suspend DirectoryConfigServiceAccountCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = DirectoryConfigServiceAccountCredentialsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.serviceAccountCredentials = mapped
    }

    internal fun build(): DirectoryConfigArgs = DirectoryConfigArgs(
        directoryName = directoryName,
        organizationalUnitDistinguishedNames = organizationalUnitDistinguishedNames,
        serviceAccountCredentials = serviceAccountCredentials,
    )
}
