@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin

import com.pulumi.aws.appstream.kotlin.outputs.FleetComputeCapacity
import com.pulumi.aws.appstream.kotlin.outputs.FleetDomainJoinInfo
import com.pulumi.aws.appstream.kotlin.outputs.FleetVpcConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.appstream.kotlin.outputs.FleetComputeCapacity.Companion.toKotlin as fleetComputeCapacityToKotlin
import com.pulumi.aws.appstream.kotlin.outputs.FleetDomainJoinInfo.Companion.toKotlin as fleetDomainJoinInfoToKotlin
import com.pulumi.aws.appstream.kotlin.outputs.FleetVpcConfig.Companion.toKotlin as fleetVpcConfigToKotlin

/**
 * Builder for [Fleet].
 */
@PulumiTagMarker
public class FleetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FleetArgs = FleetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FleetArgsBuilder.() -> Unit) {
        val builder = FleetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Fleet {
        val builtJavaResource = com.pulumi.aws.appstream.Fleet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Fleet(builtJavaResource)
    }
}

/**
 * Provides an AppStream fleet.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appstream.Fleet;
 * import com.pulumi.aws.appstream.FleetArgs;
 * import com.pulumi.aws.appstream.inputs.FleetComputeCapacityArgs;
 * import com.pulumi.aws.appstream.inputs.FleetVpcConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testFleet = new Fleet("testFleet", FleetArgs.builder()
 *             .computeCapacity(FleetComputeCapacityArgs.builder()
 *                 .desiredInstances(1)
 *                 .build())
 *             .description("test fleet")
 *             .displayName("test-fleet")
 *             .enableDefaultInternetAccess(false)
 *             .fleetType("ON_DEMAND")
 *             .idleDisconnectTimeoutInSeconds(60)
 *             .imageName("Amazon-AppStream2-Sample-Image-03-11-2023")
 *             .instanceType("stream.standard.large")
 *             .maxUserDurationInSeconds(600)
 *             .tags(Map.of("TagName", "tag-value"))
 *             .vpcConfig(FleetVpcConfigArgs.builder()
 *                 .subnetIds("subnet-06e9b13400c225127")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_appstream_fleet` using the id. For example:
 * ```sh
 *  $ pulumi import aws:appstream/fleet:Fleet example fleetNameExample
 * ```
 *
 */
public class Fleet internal constructor(
    override val javaResource: com.pulumi.aws.appstream.Fleet,
) : KotlinCustomResource(javaResource, FleetMapper) {
    /**
     * ARN of the appstream fleet.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Configuration block for the desired capacity of the fleet. See below.
     */
    public val computeCapacity: Output<FleetComputeCapacity>
        get() = javaResource.computeCapacity().applyValue({ args0 ->
            args0.let({ args0 ->
                fleetComputeCapacityToKotlin(args0)
            })
        })

    /**
     * Date and time, in UTC and extended RFC 3339 format, when the fleet was created.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * Description to display.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Amount of time that a streaming session remains active after users disconnect.
     */
    public val disconnectTimeoutInSeconds: Output<Int>
        get() = javaResource.disconnectTimeoutInSeconds().applyValue({ args0 -> args0 })

    /**
     * Human-readable friendly name for the AppStream fleet.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Configuration block for the name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. See below.
     */
    public val domainJoinInfo: Output<FleetDomainJoinInfo>
        get() = javaResource.domainJoinInfo().applyValue({ args0 ->
            args0.let({ args0 ->
                fleetDomainJoinInfoToKotlin(args0)
            })
        })

    /**
     * Enables or disables default internet access for the fleet.
     */
    public val enableDefaultInternetAccess: Output<Boolean>
        get() = javaResource.enableDefaultInternetAccess().applyValue({ args0 -> args0 })

    /**
     * Fleet type. Valid values are: `ON_DEMAND`, `ALWAYS_ON`
     */
    public val fleetType: Output<String>
        get() = javaResource.fleetType().applyValue({ args0 -> args0 })

    /**
     * ARN of the IAM role to apply to the fleet.
     */
    public val iamRoleArn: Output<String>
        get() = javaResource.iamRoleArn().applyValue({ args0 -> args0 })

    /**
     * Amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the `disconnect_timeout_in_seconds` time interval begins.
     */
    public val idleDisconnectTimeoutInSeconds: Output<Int>?
        get() = javaResource.idleDisconnectTimeoutInSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the public, private, or shared image to use.
     */
    public val imageArn: Output<String>
        get() = javaResource.imageArn().applyValue({ args0 -> args0 })

    /**
     * Name of the image used to create the fleet.
     */
    public val imageName: Output<String>
        get() = javaResource.imageName().applyValue({ args0 -> args0 })

    /**
     * Instance type to use when launching fleet instances.
     */
    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * Maximum amount of time that a streaming session can remain active, in seconds.
     */
    public val maxUserDurationInSeconds: Output<Int>
        get() = javaResource.maxUserDurationInSeconds().applyValue({ args0 -> args0 })

    /**
     * Unique name for the fleet.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * State of the fleet. Can be `STARTING`, `RUNNING`, `STOPPING` or `STOPPED`
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * AppStream 2.0 view that is displayed to your users when they stream from the fleet. When `APP` is specified, only the windows of applications opened by users display. When `DESKTOP` is specified, the standard desktop that is provided by the operating system displays. If not specified, defaults to `APP`.
     */
    public val streamView: Output<String>
        get() = javaResource.streamView().applyValue({ args0 -> args0 })

    /**
     * Map of tags to attach to AppStream instances.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Configuration block for the VPC configuration for the image builder. See below.
     */
    public val vpcConfig: Output<FleetVpcConfig>
        get() = javaResource.vpcConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                fleetVpcConfigToKotlin(args0)
            })
        })
}

public object FleetMapper : ResourceMapper<Fleet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appstream.Fleet::class == javaResource::class

    override fun map(javaResource: Resource): Fleet = Fleet(
        javaResource as
            com.pulumi.aws.appstream.Fleet,
    )
}

/**
 * @see [Fleet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Fleet].
 */
public suspend fun fleet(name: String, block: suspend FleetResourceBuilder.() -> Unit): Fleet {
    val builder = FleetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Fleet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fleet(name: String): Fleet {
    val builder = FleetResourceBuilder()
    builder.name(name)
    return builder.build()
}
