@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin

import com.pulumi.aws.appstream.FleetArgs.builder
import com.pulumi.aws.appstream.kotlin.inputs.FleetComputeCapacityArgs
import com.pulumi.aws.appstream.kotlin.inputs.FleetComputeCapacityArgsBuilder
import com.pulumi.aws.appstream.kotlin.inputs.FleetDomainJoinInfoArgs
import com.pulumi.aws.appstream.kotlin.inputs.FleetDomainJoinInfoArgsBuilder
import com.pulumi.aws.appstream.kotlin.inputs.FleetVpcConfigArgs
import com.pulumi.aws.appstream.kotlin.inputs.FleetVpcConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AppStream fleet.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appstream.Fleet;
 * import com.pulumi.aws.appstream.FleetArgs;
 * import com.pulumi.aws.appstream.inputs.FleetComputeCapacityArgs;
 * import com.pulumi.aws.appstream.inputs.FleetVpcConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testFleet = new Fleet("testFleet", FleetArgs.builder()
 *             .computeCapacity(FleetComputeCapacityArgs.builder()
 *                 .desiredInstances(1)
 *                 .build())
 *             .description("test fleet")
 *             .displayName("test-fleet")
 *             .enableDefaultInternetAccess(false)
 *             .fleetType("ON_DEMAND")
 *             .idleDisconnectTimeoutInSeconds(60)
 *             .imageName("Amazon-AppStream2-Sample-Image-03-11-2023")
 *             .instanceType("stream.standard.large")
 *             .maxUserDurationInSeconds(600)
 *             .tags(Map.of("TagName", "tag-value"))
 *             .vpcConfig(FleetVpcConfigArgs.builder()
 *                 .subnetIds("subnet-06e9b13400c225127")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_appstream_fleet` using the id. For example:
 * ```sh
 *  $ pulumi import aws:appstream/fleet:Fleet example fleetNameExample
 * ```
 * @property computeCapacity Configuration block for the desired capacity of the fleet. See below.
 * @property description Description to display.
 * @property disconnectTimeoutInSeconds Amount of time that a streaming session remains active after users disconnect.
 * @property displayName Human-readable friendly name for the AppStream fleet.
 * @property domainJoinInfo Configuration block for the name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. See below.
 * @property enableDefaultInternetAccess Enables or disables default internet access for the fleet.
 * @property fleetType Fleet type. Valid values are: `ON_DEMAND`, `ALWAYS_ON`
 * @property iamRoleArn ARN of the IAM role to apply to the fleet.
 * @property idleDisconnectTimeoutInSeconds Amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the `disconnect_timeout_in_seconds` time interval begins.
 * @property imageArn ARN of the public, private, or shared image to use.
 * @property imageName Name of the image used to create the fleet.
 * @property instanceType Instance type to use when launching fleet instances.
 * @property maxUserDurationInSeconds Maximum amount of time that a streaming session can remain active, in seconds.
 * @property name Unique name for the fleet.
 * The following arguments are optional:
 * @property streamView AppStream 2.0 view that is displayed to your users when they stream from the fleet. When `APP` is specified, only the windows of applications opened by users display. When `DESKTOP` is specified, the standard desktop that is provided by the operating system displays. If not specified, defaults to `APP`.
 * @property tags Map of tags to attach to AppStream instances.
 * @property vpcConfig Configuration block for the VPC configuration for the image builder. See below.
 */
public data class FleetArgs(
    public val computeCapacity: Output<FleetComputeCapacityArgs>? = null,
    public val description: Output<String>? = null,
    public val disconnectTimeoutInSeconds: Output<Int>? = null,
    public val displayName: Output<String>? = null,
    public val domainJoinInfo: Output<FleetDomainJoinInfoArgs>? = null,
    public val enableDefaultInternetAccess: Output<Boolean>? = null,
    public val fleetType: Output<String>? = null,
    public val iamRoleArn: Output<String>? = null,
    public val idleDisconnectTimeoutInSeconds: Output<Int>? = null,
    public val imageArn: Output<String>? = null,
    public val imageName: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val maxUserDurationInSeconds: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val streamView: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcConfig: Output<FleetVpcConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appstream.FleetArgs> {
    override fun toJava(): com.pulumi.aws.appstream.FleetArgs =
        com.pulumi.aws.appstream.FleetArgs.builder()
            .computeCapacity(computeCapacity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .disconnectTimeoutInSeconds(disconnectTimeoutInSeconds?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .domainJoinInfo(domainJoinInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enableDefaultInternetAccess(enableDefaultInternetAccess?.applyValue({ args0 -> args0 }))
            .fleetType(fleetType?.applyValue({ args0 -> args0 }))
            .iamRoleArn(iamRoleArn?.applyValue({ args0 -> args0 }))
            .idleDisconnectTimeoutInSeconds(idleDisconnectTimeoutInSeconds?.applyValue({ args0 -> args0 }))
            .imageArn(imageArn?.applyValue({ args0 -> args0 }))
            .imageName(imageName?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .maxUserDurationInSeconds(maxUserDurationInSeconds?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .streamView(streamView?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcConfig(vpcConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FleetArgs].
 */
@PulumiTagMarker
public class FleetArgsBuilder internal constructor() {
    private var computeCapacity: Output<FleetComputeCapacityArgs>? = null

    private var description: Output<String>? = null

    private var disconnectTimeoutInSeconds: Output<Int>? = null

    private var displayName: Output<String>? = null

    private var domainJoinInfo: Output<FleetDomainJoinInfoArgs>? = null

    private var enableDefaultInternetAccess: Output<Boolean>? = null

    private var fleetType: Output<String>? = null

    private var iamRoleArn: Output<String>? = null

    private var idleDisconnectTimeoutInSeconds: Output<Int>? = null

    private var imageArn: Output<String>? = null

    private var imageName: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var maxUserDurationInSeconds: Output<Int>? = null

    private var name: Output<String>? = null

    private var streamView: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcConfig: Output<FleetVpcConfigArgs>? = null

    /**
     * @param value Configuration block for the desired capacity of the fleet. See below.
     */
    @JvmName("wcfhbwpaledyrkuq")
    public suspend fun computeCapacity(`value`: Output<FleetComputeCapacityArgs>) {
        this.computeCapacity = value
    }

    /**
     * @param value Description to display.
     */
    @JvmName("scgwfhlrhjkgaipt")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Amount of time that a streaming session remains active after users disconnect.
     */
    @JvmName("yjwrkdmsjwxjbkkd")
    public suspend fun disconnectTimeoutInSeconds(`value`: Output<Int>) {
        this.disconnectTimeoutInSeconds = value
    }

    /**
     * @param value Human-readable friendly name for the AppStream fleet.
     */
    @JvmName("bvjqyfuvpvhtayxw")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Configuration block for the name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. See below.
     */
    @JvmName("lcajthadamhetbff")
    public suspend fun domainJoinInfo(`value`: Output<FleetDomainJoinInfoArgs>) {
        this.domainJoinInfo = value
    }

    /**
     * @param value Enables or disables default internet access for the fleet.
     */
    @JvmName("adeanioswkgqmlmb")
    public suspend fun enableDefaultInternetAccess(`value`: Output<Boolean>) {
        this.enableDefaultInternetAccess = value
    }

    /**
     * @param value Fleet type. Valid values are: `ON_DEMAND`, `ALWAYS_ON`
     */
    @JvmName("xfqdykspnbbwyuab")
    public suspend fun fleetType(`value`: Output<String>) {
        this.fleetType = value
    }

    /**
     * @param value ARN of the IAM role to apply to the fleet.
     */
    @JvmName("pphncnddwygcaduj")
    public suspend fun iamRoleArn(`value`: Output<String>) {
        this.iamRoleArn = value
    }

    /**
     * @param value Amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the `disconnect_timeout_in_seconds` time interval begins.
     */
    @JvmName("lkwtddybnxnaomsm")
    public suspend fun idleDisconnectTimeoutInSeconds(`value`: Output<Int>) {
        this.idleDisconnectTimeoutInSeconds = value
    }

    /**
     * @param value ARN of the public, private, or shared image to use.
     */
    @JvmName("dxovlmaqooomdybv")
    public suspend fun imageArn(`value`: Output<String>) {
        this.imageArn = value
    }

    /**
     * @param value Name of the image used to create the fleet.
     */
    @JvmName("uswrmtnbyuvkmwme")
    public suspend fun imageName(`value`: Output<String>) {
        this.imageName = value
    }

    /**
     * @param value Instance type to use when launching fleet instances.
     */
    @JvmName("vmfwaovvisaaeqtw")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Maximum amount of time that a streaming session can remain active, in seconds.
     */
    @JvmName("xckytmbrkrmxrpba")
    public suspend fun maxUserDurationInSeconds(`value`: Output<Int>) {
        this.maxUserDurationInSeconds = value
    }

    /**
     * @param value Unique name for the fleet.
     * The following arguments are optional:
     */
    @JvmName("sncpqrjhqbanaqaw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value AppStream 2.0 view that is displayed to your users when they stream from the fleet. When `APP` is specified, only the windows of applications opened by users display. When `DESKTOP` is specified, the standard desktop that is provided by the operating system displays. If not specified, defaults to `APP`.
     */
    @JvmName("osromldpvctaffvf")
    public suspend fun streamView(`value`: Output<String>) {
        this.streamView = value
    }

    /**
     * @param value Map of tags to attach to AppStream instances.
     */
    @JvmName("gbfijcwrwmpjsgga")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block for the VPC configuration for the image builder. See below.
     */
    @JvmName("fshoaqpexekuuueg")
    public suspend fun vpcConfig(`value`: Output<FleetVpcConfigArgs>) {
        this.vpcConfig = value
    }

    /**
     * @param value Configuration block for the desired capacity of the fleet. See below.
     */
    @JvmName("omgfjpitcwdfsook")
    public suspend fun computeCapacity(`value`: FleetComputeCapacityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeCapacity = mapped
    }

    /**
     * @param argument Configuration block for the desired capacity of the fleet. See below.
     */
    @JvmName("iptemicbblcbddrs")
    public suspend fun computeCapacity(argument: suspend FleetComputeCapacityArgsBuilder.() -> Unit) {
        val toBeMapped = FleetComputeCapacityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.computeCapacity = mapped
    }

    /**
     * @param value Description to display.
     */
    @JvmName("upxfdfqhfhfnhnvq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Amount of time that a streaming session remains active after users disconnect.
     */
    @JvmName("fwduuadageqealkj")
    public suspend fun disconnectTimeoutInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disconnectTimeoutInSeconds = mapped
    }

    /**
     * @param value Human-readable friendly name for the AppStream fleet.
     */
    @JvmName("amxutwickjsnkqwg")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Configuration block for the name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. See below.
     */
    @JvmName("qmytwvbluaavlxny")
    public suspend fun domainJoinInfo(`value`: FleetDomainJoinInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainJoinInfo = mapped
    }

    /**
     * @param argument Configuration block for the name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. See below.
     */
    @JvmName("nsjhbauhykntrdjw")
    public suspend fun domainJoinInfo(argument: suspend FleetDomainJoinInfoArgsBuilder.() -> Unit) {
        val toBeMapped = FleetDomainJoinInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.domainJoinInfo = mapped
    }

    /**
     * @param value Enables or disables default internet access for the fleet.
     */
    @JvmName("skowokgpgjcrorwv")
    public suspend fun enableDefaultInternetAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDefaultInternetAccess = mapped
    }

    /**
     * @param value Fleet type. Valid values are: `ON_DEMAND`, `ALWAYS_ON`
     */
    @JvmName("pserfttbexjkhjdf")
    public suspend fun fleetType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fleetType = mapped
    }

    /**
     * @param value ARN of the IAM role to apply to the fleet.
     */
    @JvmName("ktpralrotgqrnbop")
    public suspend fun iamRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamRoleArn = mapped
    }

    /**
     * @param value Amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the `disconnect_timeout_in_seconds` time interval begins.
     */
    @JvmName("jeuttxlbfwdsepfd")
    public suspend fun idleDisconnectTimeoutInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleDisconnectTimeoutInSeconds = mapped
    }

    /**
     * @param value ARN of the public, private, or shared image to use.
     */
    @JvmName("bmdfsmxcjjsyanxk")
    public suspend fun imageArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageArn = mapped
    }

    /**
     * @param value Name of the image used to create the fleet.
     */
    @JvmName("rsjfsgrqkrkmykqu")
    public suspend fun imageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageName = mapped
    }

    /**
     * @param value Instance type to use when launching fleet instances.
     */
    @JvmName("ahuvkeayrnrrtrns")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Maximum amount of time that a streaming session can remain active, in seconds.
     */
    @JvmName("aclugfwirfojfxup")
    public suspend fun maxUserDurationInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxUserDurationInSeconds = mapped
    }

    /**
     * @param value Unique name for the fleet.
     * The following arguments are optional:
     */
    @JvmName("quhtoqtavuhxkdyu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value AppStream 2.0 view that is displayed to your users when they stream from the fleet. When `APP` is specified, only the windows of applications opened by users display. When `DESKTOP` is specified, the standard desktop that is provided by the operating system displays. If not specified, defaults to `APP`.
     */
    @JvmName("qccpkuxpdjkfnlym")
    public suspend fun streamView(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamView = mapped
    }

    /**
     * @param value Map of tags to attach to AppStream instances.
     */
    @JvmName("spbxwlarivlkldkr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to attach to AppStream instances.
     */
    @JvmName("lngdeutjldfnwyvl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration block for the VPC configuration for the image builder. See below.
     */
    @JvmName("sbhvumqpkuqeqehn")
    public suspend fun vpcConfig(`value`: FleetVpcConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfig = mapped
    }

    /**
     * @param argument Configuration block for the VPC configuration for the image builder. See below.
     */
    @JvmName("fienequjfmnjrfor")
    public suspend fun vpcConfig(argument: suspend FleetVpcConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FleetVpcConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpcConfig = mapped
    }

    internal fun build(): FleetArgs = FleetArgs(
        computeCapacity = computeCapacity,
        description = description,
        disconnectTimeoutInSeconds = disconnectTimeoutInSeconds,
        displayName = displayName,
        domainJoinInfo = domainJoinInfo,
        enableDefaultInternetAccess = enableDefaultInternetAccess,
        fleetType = fleetType,
        iamRoleArn = iamRoleArn,
        idleDisconnectTimeoutInSeconds = idleDisconnectTimeoutInSeconds,
        imageArn = imageArn,
        imageName = imageName,
        instanceType = instanceType,
        maxUserDurationInSeconds = maxUserDurationInSeconds,
        name = name,
        streamView = streamView,
        tags = tags,
        vpcConfig = vpcConfig,
    )
}
