@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [FleetStackAssociation].
 */
@PulumiTagMarker
public class FleetStackAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FleetStackAssociationArgs = FleetStackAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FleetStackAssociationArgsBuilder.() -> Unit) {
        val builder = FleetStackAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): FleetStackAssociation {
        val builtJavaResource = com.pulumi.aws.appstream.FleetStackAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FleetStackAssociation(builtJavaResource)
    }
}

/**
 * Manages an AppStream Fleet Stack association.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appstream.Fleet;
 * import com.pulumi.aws.appstream.FleetArgs;
 * import com.pulumi.aws.appstream.inputs.FleetComputeCapacityArgs;
 * import com.pulumi.aws.appstream.Stack;
 * import com.pulumi.aws.appstream.FleetStackAssociation;
 * import com.pulumi.aws.appstream.FleetStackAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleFleet = new Fleet("exampleFleet", FleetArgs.builder()
 *             .imageName("Amazon-AppStream2-Sample-Image-03-11-2023")
 *             .instanceType("stream.standard.small")
 *             .computeCapacity(FleetComputeCapacityArgs.builder()
 *                 .desiredInstances(1)
 *                 .build())
 *             .build());
 *         var exampleStack = new Stack("exampleStack");
 *         var exampleFleetStackAssociation = new FleetStackAssociation("exampleFleetStackAssociation", FleetStackAssociationArgs.builder()
 *             .fleetName(exampleFleet.name())
 *             .stackName(exampleStack.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AppStream Stack Fleet Association using the `fleet_name` and `stack_name` separated by a slash (`/`). For example:
 * ```sh
 *  $ pulumi import aws:appstream/fleetStackAssociation:FleetStackAssociation example fleetName/stackName
 * ```
 *
 */
public class FleetStackAssociation internal constructor(
    override val javaResource: com.pulumi.aws.appstream.FleetStackAssociation,
) : KotlinCustomResource(javaResource, FleetStackAssociationMapper) {
    /**
     * Name of the fleet.
     */
    public val fleetName: Output<String>
        get() = javaResource.fleetName().applyValue({ args0 -> args0 })

    /**
     * Name of the stack.
     */
    public val stackName: Output<String>
        get() = javaResource.stackName().applyValue({ args0 -> args0 })
}

public object FleetStackAssociationMapper : ResourceMapper<FleetStackAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appstream.FleetStackAssociation::class == javaResource::class

    override fun map(javaResource: Resource): FleetStackAssociation =
        FleetStackAssociation(javaResource as com.pulumi.aws.appstream.FleetStackAssociation)
}

/**
 * @see [FleetStackAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FleetStackAssociation].
 */
public suspend fun fleetStackAssociation(
    name: String,
    block: suspend FleetStackAssociationResourceBuilder.() -> Unit,
): FleetStackAssociation {
    val builder = FleetStackAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FleetStackAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fleetStackAssociation(name: String): FleetStackAssociation {
    val builder = FleetStackAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
