@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin

import com.pulumi.aws.appstream.FleetStackAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an AppStream Fleet Stack association.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appstream.Fleet;
 * import com.pulumi.aws.appstream.FleetArgs;
 * import com.pulumi.aws.appstream.inputs.FleetComputeCapacityArgs;
 * import com.pulumi.aws.appstream.Stack;
 * import com.pulumi.aws.appstream.FleetStackAssociation;
 * import com.pulumi.aws.appstream.FleetStackAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleFleet = new Fleet("exampleFleet", FleetArgs.builder()
 *             .imageName("Amazon-AppStream2-Sample-Image-03-11-2023")
 *             .instanceType("stream.standard.small")
 *             .computeCapacity(FleetComputeCapacityArgs.builder()
 *                 .desiredInstances(1)
 *                 .build())
 *             .build());
 *         var exampleStack = new Stack("exampleStack");
 *         var exampleFleetStackAssociation = new FleetStackAssociation("exampleFleetStackAssociation", FleetStackAssociationArgs.builder()
 *             .fleetName(exampleFleet.name())
 *             .stackName(exampleStack.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AppStream Stack Fleet Association using the `fleet_name` and `stack_name` separated by a slash (`/`). For example:
 * ```sh
 *  $ pulumi import aws:appstream/fleetStackAssociation:FleetStackAssociation example fleetName/stackName
 * ```
 * @property fleetName Name of the fleet.
 * @property stackName Name of the stack.
 */
public data class FleetStackAssociationArgs(
    public val fleetName: Output<String>? = null,
    public val stackName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appstream.FleetStackAssociationArgs> {
    override fun toJava(): com.pulumi.aws.appstream.FleetStackAssociationArgs =
        com.pulumi.aws.appstream.FleetStackAssociationArgs.builder()
            .fleetName(fleetName?.applyValue({ args0 -> args0 }))
            .stackName(stackName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetStackAssociationArgs].
 */
@PulumiTagMarker
public class FleetStackAssociationArgsBuilder internal constructor() {
    private var fleetName: Output<String>? = null

    private var stackName: Output<String>? = null

    /**
     * @param value Name of the fleet.
     */
    @JvmName("xoafstwsdrydmcna")
    public suspend fun fleetName(`value`: Output<String>) {
        this.fleetName = value
    }

    /**
     * @param value Name of the stack.
     */
    @JvmName("mjxofxodaswdtvgr")
    public suspend fun stackName(`value`: Output<String>) {
        this.stackName = value
    }

    /**
     * @param value Name of the fleet.
     */
    @JvmName("wnenwyadkeajsqah")
    public suspend fun fleetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fleetName = mapped
    }

    /**
     * @param value Name of the stack.
     */
    @JvmName("ywfdtycklxwqmqoj")
    public suspend fun stackName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackName = mapped
    }

    internal fun build(): FleetStackAssociationArgs = FleetStackAssociationArgs(
        fleetName = fleetName,
        stackName = stackName,
    )
}
