@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin

import com.pulumi.aws.appstream.StackArgs.builder
import com.pulumi.aws.appstream.kotlin.inputs.StackAccessEndpointArgs
import com.pulumi.aws.appstream.kotlin.inputs.StackAccessEndpointArgsBuilder
import com.pulumi.aws.appstream.kotlin.inputs.StackApplicationSettingsArgs
import com.pulumi.aws.appstream.kotlin.inputs.StackApplicationSettingsArgsBuilder
import com.pulumi.aws.appstream.kotlin.inputs.StackStorageConnectorArgs
import com.pulumi.aws.appstream.kotlin.inputs.StackStorageConnectorArgsBuilder
import com.pulumi.aws.appstream.kotlin.inputs.StackStreamingExperienceSettingsArgs
import com.pulumi.aws.appstream.kotlin.inputs.StackStreamingExperienceSettingsArgsBuilder
import com.pulumi.aws.appstream.kotlin.inputs.StackUserSettingArgs
import com.pulumi.aws.appstream.kotlin.inputs.StackUserSettingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AppStream stack.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appstream.Stack;
 * import com.pulumi.aws.appstream.StackArgs;
 * import com.pulumi.aws.appstream.inputs.StackApplicationSettingsArgs;
 * import com.pulumi.aws.appstream.inputs.StackStorageConnectorArgs;
 * import com.pulumi.aws.appstream.inputs.StackUserSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Stack("example", StackArgs.builder()
 *             .applicationSettings(StackApplicationSettingsArgs.builder()
 *                 .enabled(true)
 *                 .settingsGroup("SettingsGroup")
 *                 .build())
 *             .description("stack description")
 *             .displayName("stack display name")
 *             .feedbackUrl("http://your-domain/feedback")
 *             .redirectUrl("http://your-domain/redirect")
 *             .storageConnectors(StackStorageConnectorArgs.builder()
 *                 .connectorType("HOMEFOLDERS")
 *                 .build())
 *             .tags(Map.of("TagName", "TagValue"))
 *             .userSettings(
 *                 StackUserSettingArgs.builder()
 *                     .action("CLIPBOARD_COPY_FROM_LOCAL_DEVICE")
 *                     .permission("ENABLED")
 *                     .build(),
 *                 StackUserSettingArgs.builder()
 *                     .action("CLIPBOARD_COPY_TO_LOCAL_DEVICE")
 *                     .permission("ENABLED")
 *                     .build(),
 *                 StackUserSettingArgs.builder()
 *                     .action("DOMAIN_PASSWORD_SIGNIN")
 *                     .permission("ENABLED")
 *                     .build(),
 *                 StackUserSettingArgs.builder()
 *                     .action("DOMAIN_SMART_CARD_SIGNIN")
 *                     .permission("DISABLED")
 *                     .build(),
 *                 StackUserSettingArgs.builder()
 *                     .action("FILE_DOWNLOAD")
 *                     .permission("ENABLED")
 *                     .build(),
 *                 StackUserSettingArgs.builder()
 *                     .action("FILE_UPLOAD")
 *                     .permission("ENABLED")
 *                     .build(),
 *                 StackUserSettingArgs.builder()
 *                     .action("PRINTING_TO_LOCAL_DEVICE")
 *                     .permission("ENABLED")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_appstream_stack` using the id. For example:
 * ```sh
 *  $ pulumi import aws:appstream/stack:Stack example stackID
 * ```
 * @property accessEndpoints Set of configuration blocks defining the interface VPC endpoints. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
 * See `access_endpoints` below.
 * @property applicationSettings Settings for application settings persistence.
 * See `application_settings` below.
 * @property description Description for the AppStream stack.
 * @property displayName Stack name to display.
 * @property embedHostDomains Domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
 * @property feedbackUrl URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed. .
 * @property name Unique name for the AppStream stack.
 * The following arguments are optional:
 * @property redirectUrl URL that users are redirected to after their streaming session ends.
 * @property storageConnectors Configuration block for the storage connectors to enable.
 * See `storage_connectors` below.
 * @property streamingExperienceSettings The streaming protocol you want your stack to prefer. This can be UDP or TCP. Currently, UDP is only supported in the Windows native client.
 * See `streaming_experience_settings` below.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property userSettings Configuration block for the actions that are enabled or disabled for users during their streaming sessions. If not provided, these settings are configured automatically by AWS. If provided, the configuration should include a block for each configurable action.
 * See `user_settings` below.
 */
public data class StackArgs(
    public val accessEndpoints: Output<List<StackAccessEndpointArgs>>? = null,
    public val applicationSettings: Output<StackApplicationSettingsArgs>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val embedHostDomains: Output<List<String>>? = null,
    public val feedbackUrl: Output<String>? = null,
    public val name: Output<String>? = null,
    public val redirectUrl: Output<String>? = null,
    public val storageConnectors: Output<List<StackStorageConnectorArgs>>? = null,
    public val streamingExperienceSettings: Output<StackStreamingExperienceSettingsArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userSettings: Output<List<StackUserSettingArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.appstream.StackArgs> {
    override fun toJava(): com.pulumi.aws.appstream.StackArgs =
        com.pulumi.aws.appstream.StackArgs.builder()
            .accessEndpoints(
                accessEndpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .applicationSettings(
                applicationSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .embedHostDomains(embedHostDomains?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .feedbackUrl(feedbackUrl?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .redirectUrl(redirectUrl?.applyValue({ args0 -> args0 }))
            .storageConnectors(
                storageConnectors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .streamingExperienceSettings(
                streamingExperienceSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userSettings(
                userSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [StackArgs].
 */
@PulumiTagMarker
public class StackArgsBuilder internal constructor() {
    private var accessEndpoints: Output<List<StackAccessEndpointArgs>>? = null

    private var applicationSettings: Output<StackApplicationSettingsArgs>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var embedHostDomains: Output<List<String>>? = null

    private var feedbackUrl: Output<String>? = null

    private var name: Output<String>? = null

    private var redirectUrl: Output<String>? = null

    private var storageConnectors: Output<List<StackStorageConnectorArgs>>? = null

    private var streamingExperienceSettings: Output<StackStreamingExperienceSettingsArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userSettings: Output<List<StackUserSettingArgs>>? = null

    /**
     * @param value Set of configuration blocks defining the interface VPC endpoints. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
     * See `access_endpoints` below.
     */
    @JvmName("oisytcxjsuwyhitl")
    public suspend fun accessEndpoints(`value`: Output<List<StackAccessEndpointArgs>>) {
        this.accessEndpoints = value
    }

    @JvmName("idarottchbmqvlde")
    public suspend fun accessEndpoints(vararg values: Output<StackAccessEndpointArgs>) {
        this.accessEndpoints = Output.all(values.asList())
    }

    /**
     * @param values Set of configuration blocks defining the interface VPC endpoints. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
     * See `access_endpoints` below.
     */
    @JvmName("bkdrrhdwhisbbkow")
    public suspend fun accessEndpoints(values: List<Output<StackAccessEndpointArgs>>) {
        this.accessEndpoints = Output.all(values)
    }

    /**
     * @param value Settings for application settings persistence.
     * See `application_settings` below.
     */
    @JvmName("hubeqmvjfifrvqlp")
    public suspend fun applicationSettings(`value`: Output<StackApplicationSettingsArgs>) {
        this.applicationSettings = value
    }

    /**
     * @param value Description for the AppStream stack.
     */
    @JvmName("fesrppykmdywofom")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Stack name to display.
     */
    @JvmName("rqvqochvdsjjjypd")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
     */
    @JvmName("rciepfimsucxnlpf")
    public suspend fun embedHostDomains(`value`: Output<List<String>>) {
        this.embedHostDomains = value
    }

    @JvmName("ljkpplywhqowcjcn")
    public suspend fun embedHostDomains(vararg values: Output<String>) {
        this.embedHostDomains = Output.all(values.asList())
    }

    /**
     * @param values Domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
     */
    @JvmName("hqbwblkqniladksf")
    public suspend fun embedHostDomains(values: List<Output<String>>) {
        this.embedHostDomains = Output.all(values)
    }

    /**
     * @param value URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed. .
     */
    @JvmName("engrtruahbwhiecb")
    public suspend fun feedbackUrl(`value`: Output<String>) {
        this.feedbackUrl = value
    }

    /**
     * @param value Unique name for the AppStream stack.
     * The following arguments are optional:
     */
    @JvmName("cmynblidxrhmqrir")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value URL that users are redirected to after their streaming session ends.
     */
    @JvmName("yfppwejlyyssxddf")
    public suspend fun redirectUrl(`value`: Output<String>) {
        this.redirectUrl = value
    }

    /**
     * @param value Configuration block for the storage connectors to enable.
     * See `storage_connectors` below.
     */
    @JvmName("hluwdceylahucvnt")
    public suspend fun storageConnectors(`value`: Output<List<StackStorageConnectorArgs>>) {
        this.storageConnectors = value
    }

    @JvmName("galiteuchvpffasi")
    public suspend fun storageConnectors(vararg values: Output<StackStorageConnectorArgs>) {
        this.storageConnectors = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for the storage connectors to enable.
     * See `storage_connectors` below.
     */
    @JvmName("iyclkfqsylqtnnfl")
    public suspend fun storageConnectors(values: List<Output<StackStorageConnectorArgs>>) {
        this.storageConnectors = Output.all(values)
    }

    /**
     * @param value The streaming protocol you want your stack to prefer. This can be UDP or TCP. Currently, UDP is only supported in the Windows native client.
     * See `streaming_experience_settings` below.
     */
    @JvmName("qpbooyirhdmtfgnc")
    public suspend
    fun streamingExperienceSettings(`value`: Output<StackStreamingExperienceSettingsArgs>) {
        this.streamingExperienceSettings = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kkgteptqrqkugsro")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block for the actions that are enabled or disabled for users during their streaming sessions. If not provided, these settings are configured automatically by AWS. If provided, the configuration should include a block for each configurable action.
     * See `user_settings` below.
     */
    @JvmName("qqxvgidmtdhjwqqc")
    public suspend fun userSettings(`value`: Output<List<StackUserSettingArgs>>) {
        this.userSettings = value
    }

    @JvmName("vjcdpqkdsbmcgjjk")
    public suspend fun userSettings(vararg values: Output<StackUserSettingArgs>) {
        this.userSettings = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for the actions that are enabled or disabled for users during their streaming sessions. If not provided, these settings are configured automatically by AWS. If provided, the configuration should include a block for each configurable action.
     * See `user_settings` below.
     */
    @JvmName("vawqbnukklspksdk")
    public suspend fun userSettings(values: List<Output<StackUserSettingArgs>>) {
        this.userSettings = Output.all(values)
    }

    /**
     * @param value Set of configuration blocks defining the interface VPC endpoints. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
     * See `access_endpoints` below.
     */
    @JvmName("vlmwgaivgumoutrq")
    public suspend fun accessEndpoints(`value`: List<StackAccessEndpointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessEndpoints = mapped
    }

    /**
     * @param argument Set of configuration blocks defining the interface VPC endpoints. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
     * See `access_endpoints` below.
     */
    @JvmName("ngfuushbynsytqkr")
    public suspend
    fun accessEndpoints(argument: List<suspend StackAccessEndpointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StackAccessEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.accessEndpoints = mapped
    }

    /**
     * @param argument Set of configuration blocks defining the interface VPC endpoints. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
     * See `access_endpoints` below.
     */
    @JvmName("ekugslpvbiowjxgk")
    public suspend fun accessEndpoints(
        vararg
        argument: suspend StackAccessEndpointArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            StackAccessEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.accessEndpoints = mapped
    }

    /**
     * @param argument Set of configuration blocks defining the interface VPC endpoints. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
     * See `access_endpoints` below.
     */
    @JvmName("fxjpwfkdkgesxbdn")
    public suspend fun accessEndpoints(argument: suspend StackAccessEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StackAccessEndpointArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.accessEndpoints = mapped
    }

    /**
     * @param values Set of configuration blocks defining the interface VPC endpoints. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
     * See `access_endpoints` below.
     */
    @JvmName("rwbqbljxnbfirbaj")
    public suspend fun accessEndpoints(vararg values: StackAccessEndpointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessEndpoints = mapped
    }

    /**
     * @param value Settings for application settings persistence.
     * See `application_settings` below.
     */
    @JvmName("gspelhbbunsujija")
    public suspend fun applicationSettings(`value`: StackApplicationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationSettings = mapped
    }

    /**
     * @param argument Settings for application settings persistence.
     * See `application_settings` below.
     */
    @JvmName("xrjfuqftmmjhmgcv")
    public suspend
    fun applicationSettings(argument: suspend StackApplicationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = StackApplicationSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.applicationSettings = mapped
    }

    /**
     * @param value Description for the AppStream stack.
     */
    @JvmName("glavfrcdxjetvbwv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Stack name to display.
     */
    @JvmName("sgjdmckptyqjhvqw")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
     */
    @JvmName("wumlhglfbtcaavkh")
    public suspend fun embedHostDomains(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.embedHostDomains = mapped
    }

    /**
     * @param values Domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
     */
    @JvmName("kqknjfdonbnbguef")
    public suspend fun embedHostDomains(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.embedHostDomains = mapped
    }

    /**
     * @param value URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed. .
     */
    @JvmName("usveeawuwlipxjbt")
    public suspend fun feedbackUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.feedbackUrl = mapped
    }

    /**
     * @param value Unique name for the AppStream stack.
     * The following arguments are optional:
     */
    @JvmName("yjthadwblndpjfrx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value URL that users are redirected to after their streaming session ends.
     */
    @JvmName("odapkfagltxtsgnn")
    public suspend fun redirectUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redirectUrl = mapped
    }

    /**
     * @param value Configuration block for the storage connectors to enable.
     * See `storage_connectors` below.
     */
    @JvmName("amopakxbrgtpefps")
    public suspend fun storageConnectors(`value`: List<StackStorageConnectorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageConnectors = mapped
    }

    /**
     * @param argument Configuration block for the storage connectors to enable.
     * See `storage_connectors` below.
     */
    @JvmName("jqialbgwvipklvgh")
    public suspend
    fun storageConnectors(argument: List<suspend StackStorageConnectorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StackStorageConnectorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageConnectors = mapped
    }

    /**
     * @param argument Configuration block for the storage connectors to enable.
     * See `storage_connectors` below.
     */
    @JvmName("jywruyhmuloablbt")
    public suspend fun storageConnectors(
        vararg
        argument: suspend StackStorageConnectorArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            StackStorageConnectorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageConnectors = mapped
    }

    /**
     * @param argument Configuration block for the storage connectors to enable.
     * See `storage_connectors` below.
     */
    @JvmName("yiyxeypnagvcnjvx")
    public suspend
    fun storageConnectors(argument: suspend StackStorageConnectorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StackStorageConnectorArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.storageConnectors = mapped
    }

    /**
     * @param values Configuration block for the storage connectors to enable.
     * See `storage_connectors` below.
     */
    @JvmName("tnnsubvohyvscdrh")
    public suspend fun storageConnectors(vararg values: StackStorageConnectorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageConnectors = mapped
    }

    /**
     * @param value The streaming protocol you want your stack to prefer. This can be UDP or TCP. Currently, UDP is only supported in the Windows native client.
     * See `streaming_experience_settings` below.
     */
    @JvmName("mccxkinvhvllormf")
    public suspend fun streamingExperienceSettings(`value`: StackStreamingExperienceSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamingExperienceSettings = mapped
    }

    /**
     * @param argument The streaming protocol you want your stack to prefer. This can be UDP or TCP. Currently, UDP is only supported in the Windows native client.
     * See `streaming_experience_settings` below.
     */
    @JvmName("aqhxwcspvpnipmox")
    public suspend
    fun streamingExperienceSettings(argument: suspend StackStreamingExperienceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = StackStreamingExperienceSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.streamingExperienceSettings = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mhyiaujafdfcuamf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("erlywjjkxjhibubg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration block for the actions that are enabled or disabled for users during their streaming sessions. If not provided, these settings are configured automatically by AWS. If provided, the configuration should include a block for each configurable action.
     * See `user_settings` below.
     */
    @JvmName("rybkbvwmsmuhupwo")
    public suspend fun userSettings(`value`: List<StackUserSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userSettings = mapped
    }

    /**
     * @param argument Configuration block for the actions that are enabled or disabled for users during their streaming sessions. If not provided, these settings are configured automatically by AWS. If provided, the configuration should include a block for each configurable action.
     * See `user_settings` below.
     */
    @JvmName("vcyabqfspltdnxsq")
    public suspend fun userSettings(argument: List<suspend StackUserSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StackUserSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.userSettings = mapped
    }

    /**
     * @param argument Configuration block for the actions that are enabled or disabled for users during their streaming sessions. If not provided, these settings are configured automatically by AWS. If provided, the configuration should include a block for each configurable action.
     * See `user_settings` below.
     */
    @JvmName("avddttchtsvniwvd")
    public suspend fun userSettings(vararg argument: suspend StackUserSettingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            StackUserSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.userSettings = mapped
    }

    /**
     * @param argument Configuration block for the actions that are enabled or disabled for users during their streaming sessions. If not provided, these settings are configured automatically by AWS. If provided, the configuration should include a block for each configurable action.
     * See `user_settings` below.
     */
    @JvmName("gpwuvgpxapddtvwx")
    public suspend fun userSettings(argument: suspend StackUserSettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StackUserSettingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.userSettings = mapped
    }

    /**
     * @param values Configuration block for the actions that are enabled or disabled for users during their streaming sessions. If not provided, these settings are configured automatically by AWS. If provided, the configuration should include a block for each configurable action.
     * See `user_settings` below.
     */
    @JvmName("yapvgqjlbkpaxisf")
    public suspend fun userSettings(vararg values: StackUserSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userSettings = mapped
    }

    internal fun build(): StackArgs = StackArgs(
        accessEndpoints = accessEndpoints,
        applicationSettings = applicationSettings,
        description = description,
        displayName = displayName,
        embedHostDomains = embedHostDomains,
        feedbackUrl = feedbackUrl,
        name = name,
        redirectUrl = redirectUrl,
        storageConnectors = storageConnectors,
        streamingExperienceSettings = streamingExperienceSettings,
        tags = tags,
        userSettings = userSettings,
    )
}
