@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin

import com.pulumi.aws.appstream.UserStackAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an AppStream User Stack association.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appstream.Stack;
 * import com.pulumi.aws.appstream.User;
 * import com.pulumi.aws.appstream.UserArgs;
 * import com.pulumi.aws.appstream.UserStackAssociation;
 * import com.pulumi.aws.appstream.UserStackAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testStack = new Stack("testStack");
 *         var testUser = new User("testUser", UserArgs.builder()
 *             .authenticationType("USERPOOL")
 *             .userName("EMAIL")
 *             .build());
 *         var testUserStackAssociation = new UserStackAssociation("testUserStackAssociation", UserStackAssociationArgs.builder()
 *             .authenticationType(testUser.authenticationType())
 *             .stackName(testStack.name())
 *             .userName(testUser.userName())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AppStream User Stack Association using the `user_name`, `authentication_type`, and `stack_name`, separated by a slash (`/`). For example:
 * ```sh
 *  $ pulumi import aws:appstream/userStackAssociation:UserStackAssociation example userName/auhtenticationType/stackName
 * ```
 * @property authenticationType Authentication type for the user.
 * @property sendEmailNotification Whether a welcome email is sent to a user after the user is created in the user pool.
 * @property stackName Name of the stack that is associated with the user.
 * @property userName Email address of the user who is associated with the stack.
 * The following arguments are optional:
 */
public data class UserStackAssociationArgs(
    public val authenticationType: Output<String>? = null,
    public val sendEmailNotification: Output<Boolean>? = null,
    public val stackName: Output<String>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appstream.UserStackAssociationArgs> {
    override fun toJava(): com.pulumi.aws.appstream.UserStackAssociationArgs =
        com.pulumi.aws.appstream.UserStackAssociationArgs.builder()
            .authenticationType(authenticationType?.applyValue({ args0 -> args0 }))
            .sendEmailNotification(sendEmailNotification?.applyValue({ args0 -> args0 }))
            .stackName(stackName?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserStackAssociationArgs].
 */
@PulumiTagMarker
public class UserStackAssociationArgsBuilder internal constructor() {
    private var authenticationType: Output<String>? = null

    private var sendEmailNotification: Output<Boolean>? = null

    private var stackName: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value Authentication type for the user.
     */
    @JvmName("pyxtgmajhgvorytm")
    public suspend fun authenticationType(`value`: Output<String>) {
        this.authenticationType = value
    }

    /**
     * @param value Whether a welcome email is sent to a user after the user is created in the user pool.
     */
    @JvmName("mymmjeencubjjobb")
    public suspend fun sendEmailNotification(`value`: Output<Boolean>) {
        this.sendEmailNotification = value
    }

    /**
     * @param value Name of the stack that is associated with the user.
     */
    @JvmName("ujkdgtglkbxfkbma")
    public suspend fun stackName(`value`: Output<String>) {
        this.stackName = value
    }

    /**
     * @param value Email address of the user who is associated with the stack.
     * The following arguments are optional:
     */
    @JvmName("nagnvlkpajdlewly")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value Authentication type for the user.
     */
    @JvmName("nfnsjktejlrlerck")
    public suspend fun authenticationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Whether a welcome email is sent to a user after the user is created in the user pool.
     */
    @JvmName("ivjuevuapaihincx")
    public suspend fun sendEmailNotification(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendEmailNotification = mapped
    }

    /**
     * @param value Name of the stack that is associated with the user.
     */
    @JvmName("ulmaqxoidcddkrkv")
    public suspend fun stackName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackName = mapped
    }

    /**
     * @param value Email address of the user who is associated with the stack.
     * The following arguments are optional:
     */
    @JvmName("uqqdemvrlwelaqpo")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): UserStackAssociationArgs = UserStackAssociationArgs(
        authenticationType = authenticationType,
        sendEmailNotification = sendEmailNotification,
        stackName = stackName,
        userName = userName,
    )
}
