@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin.inputs

import com.pulumi.aws.appstream.inputs.DirectoryConfigServiceAccountCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName User name of the account. This account must have the following privileges: create computer objects, join computers to the domain, and change/reset the password on descendant computer objects for the organizational units specified.
 * @property accountPassword Password for the account.
 */
public data class DirectoryConfigServiceAccountCredentialsArgs(
    public val accountName: Output<String>,
    public val accountPassword: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appstream.inputs.DirectoryConfigServiceAccountCredentialsArgs> {
    override fun toJava():
        com.pulumi.aws.appstream.inputs.DirectoryConfigServiceAccountCredentialsArgs =
        com.pulumi.aws.appstream.inputs.DirectoryConfigServiceAccountCredentialsArgs.builder()
            .accountName(accountName.applyValue({ args0 -> args0 }))
            .accountPassword(accountPassword.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DirectoryConfigServiceAccountCredentialsArgs].
 */
@PulumiTagMarker
public class DirectoryConfigServiceAccountCredentialsArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var accountPassword: Output<String>? = null

    /**
     * @param value User name of the account. This account must have the following privileges: create computer objects, join computers to the domain, and change/reset the password on descendant computer objects for the organizational units specified.
     */
    @JvmName("hbtspiwhrctsoigr")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Password for the account.
     */
    @JvmName("slpkckdtihwwexxv")
    public suspend fun accountPassword(`value`: Output<String>) {
        this.accountPassword = value
    }

    /**
     * @param value User name of the account. This account must have the following privileges: create computer objects, join computers to the domain, and change/reset the password on descendant computer objects for the organizational units specified.
     */
    @JvmName("npcfnoqvqjjxdpbe")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Password for the account.
     */
    @JvmName("mbuayfefydtfclnp")
    public suspend fun accountPassword(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountPassword = mapped
    }

    internal fun build(): DirectoryConfigServiceAccountCredentialsArgs =
        DirectoryConfigServiceAccountCredentialsArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            accountPassword = accountPassword ?: throw PulumiNullFieldException("accountPassword"),
        )
}
