@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin.inputs

import com.pulumi.aws.appstream.inputs.FleetComputeCapacityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property available Number of currently available instances that can be used to stream sessions.
 * @property desiredInstances Desired number of streaming instances.
 * @property inUse Number of instances in use for streaming.
 * @property running Total number of simultaneous streaming instances that are running.
 */
public data class FleetComputeCapacityArgs(
    public val available: Output<Int>? = null,
    public val desiredInstances: Output<Int>,
    public val inUse: Output<Int>? = null,
    public val running: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.appstream.inputs.FleetComputeCapacityArgs> {
    override fun toJava(): com.pulumi.aws.appstream.inputs.FleetComputeCapacityArgs =
        com.pulumi.aws.appstream.inputs.FleetComputeCapacityArgs.builder()
            .available(available?.applyValue({ args0 -> args0 }))
            .desiredInstances(desiredInstances.applyValue({ args0 -> args0 }))
            .inUse(inUse?.applyValue({ args0 -> args0 }))
            .running(running?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetComputeCapacityArgs].
 */
@PulumiTagMarker
public class FleetComputeCapacityArgsBuilder internal constructor() {
    private var available: Output<Int>? = null

    private var desiredInstances: Output<Int>? = null

    private var inUse: Output<Int>? = null

    private var running: Output<Int>? = null

    /**
     * @param value Number of currently available instances that can be used to stream sessions.
     */
    @JvmName("ckdygmmgwwpypvgr")
    public suspend fun available(`value`: Output<Int>) {
        this.available = value
    }

    /**
     * @param value Desired number of streaming instances.
     */
    @JvmName("bfvqplfrpsqtqqsb")
    public suspend fun desiredInstances(`value`: Output<Int>) {
        this.desiredInstances = value
    }

    /**
     * @param value Number of instances in use for streaming.
     */
    @JvmName("kddftpfxdxsxxlkf")
    public suspend fun inUse(`value`: Output<Int>) {
        this.inUse = value
    }

    /**
     * @param value Total number of simultaneous streaming instances that are running.
     */
    @JvmName("pnkmfecifxhattrb")
    public suspend fun running(`value`: Output<Int>) {
        this.running = value
    }

    /**
     * @param value Number of currently available instances that can be used to stream sessions.
     */
    @JvmName("jhxhfjeiowhndtow")
    public suspend fun available(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.available = mapped
    }

    /**
     * @param value Desired number of streaming instances.
     */
    @JvmName("kthfcmbuonhbaord")
    public suspend fun desiredInstances(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.desiredInstances = mapped
    }

    /**
     * @param value Number of instances in use for streaming.
     */
    @JvmName("ybrbjqrjocabkgop")
    public suspend fun inUse(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inUse = mapped
    }

    /**
     * @param value Total number of simultaneous streaming instances that are running.
     */
    @JvmName("uljaulxvbuqluyjm")
    public suspend fun running(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.running = mapped
    }

    internal fun build(): FleetComputeCapacityArgs = FleetComputeCapacityArgs(
        available = available,
        desiredInstances = desiredInstances ?: throw PulumiNullFieldException("desiredInstances"),
        inUse = inUse,
        running = running,
    )
}
