@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin.inputs

import com.pulumi.aws.appstream.inputs.ImageBuilderVpcConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroupIds Identifiers of the security groups for the image builder or image builder.
 * @property subnetIds Identifier of the subnet to which a network interface is attached from the image builder instance.
 */
public data class ImageBuilderVpcConfigArgs(
    public val securityGroupIds: Output<List<String>>? = null,
    public val subnetIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.appstream.inputs.ImageBuilderVpcConfigArgs> {
    override fun toJava(): com.pulumi.aws.appstream.inputs.ImageBuilderVpcConfigArgs =
        com.pulumi.aws.appstream.inputs.ImageBuilderVpcConfigArgs.builder()
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ImageBuilderVpcConfigArgs].
 */
@PulumiTagMarker
public class ImageBuilderVpcConfigArgsBuilder internal constructor() {
    private var securityGroupIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    /**
     * @param value Identifiers of the security groups for the image builder or image builder.
     */
    @JvmName("tvjxyscxhknvmbij")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("oaefepxqmrmjcbbj")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values Identifiers of the security groups for the image builder or image builder.
     */
    @JvmName("mbvckgihekwducik")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value Identifier of the subnet to which a network interface is attached from the image builder instance.
     */
    @JvmName("xkytpxsejwsoflaw")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("jijkjphajtgfhuuf")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values Identifier of the subnet to which a network interface is attached from the image builder instance.
     */
    @JvmName("dlxhyxkhgytxwlhe")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value Identifiers of the security groups for the image builder or image builder.
     */
    @JvmName("ybjogqknfthhqusb")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values Identifiers of the security groups for the image builder or image builder.
     */
    @JvmName("wnefjvutdopkexds")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value Identifier of the subnet to which a network interface is attached from the image builder instance.
     */
    @JvmName("sqrscoewwaejmsxb")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values Identifier of the subnet to which a network interface is attached from the image builder instance.
     */
    @JvmName("xrftdjlgneqsvvyl")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    internal fun build(): ImageBuilderVpcConfigArgs = ImageBuilderVpcConfigArgs(
        securityGroupIds = securityGroupIds,
        subnetIds = subnetIds,
    )
}
