@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin.inputs

import com.pulumi.aws.appstream.inputs.StackStorageConnectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property connectorType Type of storage connector.
 * Valid values are `HOMEFOLDERS`, `GOOGLE_DRIVE`, or `ONE_DRIVE`.
 * @property domains Names of the domains for the account.
 * @property resourceIdentifier ARN of the storage connector.
 */
public data class StackStorageConnectorArgs(
    public val connectorType: Output<String>,
    public val domains: Output<List<String>>? = null,
    public val resourceIdentifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appstream.inputs.StackStorageConnectorArgs> {
    override fun toJava(): com.pulumi.aws.appstream.inputs.StackStorageConnectorArgs =
        com.pulumi.aws.appstream.inputs.StackStorageConnectorArgs.builder()
            .connectorType(connectorType.applyValue({ args0 -> args0 }))
            .domains(domains?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceIdentifier(resourceIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StackStorageConnectorArgs].
 */
@PulumiTagMarker
public class StackStorageConnectorArgsBuilder internal constructor() {
    private var connectorType: Output<String>? = null

    private var domains: Output<List<String>>? = null

    private var resourceIdentifier: Output<String>? = null

    /**
     * @param value Type of storage connector.
     * Valid values are `HOMEFOLDERS`, `GOOGLE_DRIVE`, or `ONE_DRIVE`.
     */
    @JvmName("lsaobluwmckvvupo")
    public suspend fun connectorType(`value`: Output<String>) {
        this.connectorType = value
    }

    /**
     * @param value Names of the domains for the account.
     */
    @JvmName("beewkibsntdmixef")
    public suspend fun domains(`value`: Output<List<String>>) {
        this.domains = value
    }

    @JvmName("dfyensqwprijluma")
    public suspend fun domains(vararg values: Output<String>) {
        this.domains = Output.all(values.asList())
    }

    /**
     * @param values Names of the domains for the account.
     */
    @JvmName("wlldmmklowbandmk")
    public suspend fun domains(values: List<Output<String>>) {
        this.domains = Output.all(values)
    }

    /**
     * @param value ARN of the storage connector.
     */
    @JvmName("qovsaajbohavcpgr")
    public suspend fun resourceIdentifier(`value`: Output<String>) {
        this.resourceIdentifier = value
    }

    /**
     * @param value Type of storage connector.
     * Valid values are `HOMEFOLDERS`, `GOOGLE_DRIVE`, or `ONE_DRIVE`.
     */
    @JvmName("qvvgutgupffiuddi")
    public suspend fun connectorType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectorType = mapped
    }

    /**
     * @param value Names of the domains for the account.
     */
    @JvmName("yrevuceqnvfyecul")
    public suspend fun domains(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domains = mapped
    }

    /**
     * @param values Names of the domains for the account.
     */
    @JvmName("biurvnaklwxbqycv")
    public suspend fun domains(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domains = mapped
    }

    /**
     * @param value ARN of the storage connector.
     */
    @JvmName("rsjbstwrfmtswebq")
    public suspend fun resourceIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceIdentifier = mapped
    }

    internal fun build(): StackStorageConnectorArgs = StackStorageConnectorArgs(
        connectorType = connectorType ?: throw PulumiNullFieldException("connectorType"),
        domains = domains,
        resourceIdentifier = resourceIdentifier,
    )
}
