@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin.inputs

import com.pulumi.aws.appstream.inputs.StackStreamingExperienceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property preferredProtocol The preferred protocol that you want to use while streaming your application.
 * Valid values are `TCP` and `UDP`.
 */
public data class StackStreamingExperienceSettingsArgs(
    public val preferredProtocol: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appstream.inputs.StackStreamingExperienceSettingsArgs> {
    override fun toJava(): com.pulumi.aws.appstream.inputs.StackStreamingExperienceSettingsArgs =
        com.pulumi.aws.appstream.inputs.StackStreamingExperienceSettingsArgs.builder()
            .preferredProtocol(preferredProtocol?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StackStreamingExperienceSettingsArgs].
 */
@PulumiTagMarker
public class StackStreamingExperienceSettingsArgsBuilder internal constructor() {
    private var preferredProtocol: Output<String>? = null

    /**
     * @param value The preferred protocol that you want to use while streaming your application.
     * Valid values are `TCP` and `UDP`.
     */
    @JvmName("vrbsupbfxxlybabu")
    public suspend fun preferredProtocol(`value`: Output<String>) {
        this.preferredProtocol = value
    }

    /**
     * @param value The preferred protocol that you want to use while streaming your application.
     * Valid values are `TCP` and `UDP`.
     */
    @JvmName("getrmbqbiiswweqx")
    public suspend fun preferredProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredProtocol = mapped
    }

    internal fun build(): StackStreamingExperienceSettingsArgs = StackStreamingExperienceSettingsArgs(
        preferredProtocol = preferredProtocol,
    )
}
