@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin.inputs

import com.pulumi.aws.appstream.inputs.StackUserSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property action Action that is enabled or disabled.
 * Valid values are `CLIPBOARD_COPY_FROM_LOCAL_DEVICE`,  `CLIPBOARD_COPY_TO_LOCAL_DEVICE`, `FILE_UPLOAD`, `FILE_DOWNLOAD`, `PRINTING_TO_LOCAL_DEVICE`, `DOMAIN_PASSWORD_SIGNIN`, or `DOMAIN_SMART_CARD_SIGNIN`.
 * @property permission Whether the action is enabled or disabled.
 * Valid values are `ENABLED` or `DISABLED`.
 */
public data class StackUserSettingArgs(
    public val action: Output<String>,
    public val permission: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appstream.inputs.StackUserSettingArgs> {
    override fun toJava(): com.pulumi.aws.appstream.inputs.StackUserSettingArgs =
        com.pulumi.aws.appstream.inputs.StackUserSettingArgs.builder()
            .action(action.applyValue({ args0 -> args0 }))
            .permission(permission.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StackUserSettingArgs].
 */
@PulumiTagMarker
public class StackUserSettingArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var permission: Output<String>? = null

    /**
     * @param value Action that is enabled or disabled.
     * Valid values are `CLIPBOARD_COPY_FROM_LOCAL_DEVICE`,  `CLIPBOARD_COPY_TO_LOCAL_DEVICE`, `FILE_UPLOAD`, `FILE_DOWNLOAD`, `PRINTING_TO_LOCAL_DEVICE`, `DOMAIN_PASSWORD_SIGNIN`, or `DOMAIN_SMART_CARD_SIGNIN`.
     */
    @JvmName("rdjimkdtjbewawsh")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value Whether the action is enabled or disabled.
     * Valid values are `ENABLED` or `DISABLED`.
     */
    @JvmName("usrpighocmexiacb")
    public suspend fun permission(`value`: Output<String>) {
        this.permission = value
    }

    /**
     * @param value Action that is enabled or disabled.
     * Valid values are `CLIPBOARD_COPY_FROM_LOCAL_DEVICE`,  `CLIPBOARD_COPY_TO_LOCAL_DEVICE`, `FILE_UPLOAD`, `FILE_DOWNLOAD`, `PRINTING_TO_LOCAL_DEVICE`, `DOMAIN_PASSWORD_SIGNIN`, or `DOMAIN_SMART_CARD_SIGNIN`.
     */
    @JvmName("dvovpthknvlnlmgf")
    public suspend fun action(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Whether the action is enabled or disabled.
     * Valid values are `ENABLED` or `DISABLED`.
     */
    @JvmName("cljynsstueoyvwuu")
    public suspend fun permission(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permission = mapped
    }

    internal fun build(): StackUserSettingArgs = StackUserSettingArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        permission = permission ?: throw PulumiNullFieldException("permission"),
    )
}
