@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property available Number of currently available instances that can be used to stream sessions.
 * @property desiredInstances Desired number of streaming instances.
 * @property inUse Number of instances in use for streaming.
 * @property running Total number of simultaneous streaming instances that are running.
 */
public data class FleetComputeCapacity(
    public val available: Int? = null,
    public val desiredInstances: Int,
    public val inUse: Int? = null,
    public val running: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appstream.outputs.FleetComputeCapacity):
            FleetComputeCapacity = FleetComputeCapacity(
            available = javaType.available().map({ args0 -> args0 }).orElse(null),
            desiredInstances = javaType.desiredInstances(),
            inUse = javaType.inUse().map({ args0 -> args0 }).orElse(null),
            running = javaType.running().map({ args0 -> args0 }).orElse(null),
        )
    }
}
