@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property securityGroupIds Identifiers of the security groups for the fleet or image builder.
 * @property subnetIds Identifiers of the subnets to which a network interface is attached from the fleet instance or image builder instance.
 */
public data class FleetVpcConfig(
    public val securityGroupIds: List<String>? = null,
    public val subnetIds: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appstream.outputs.FleetVpcConfig): FleetVpcConfig =
            FleetVpcConfig(
                securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
                subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            )
    }
}
