@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property directoryName Fully qualified name of the directory (for example, corp.example.com).
 * @property organizationalUnitDistinguishedName Distinguished name of the organizational unit for computer accounts.
 */
public data class ImageBuilderDomainJoinInfo(
    public val directoryName: String? = null,
    public val organizationalUnitDistinguishedName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appstream.outputs.ImageBuilderDomainJoinInfo):
            ImageBuilderDomainJoinInfo = ImageBuilderDomainJoinInfo(
            directoryName = javaType.directoryName().map({ args0 -> args0 }).orElse(null),
            organizationalUnitDistinguishedName = javaType.organizationalUnitDistinguishedName().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
