@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property securityGroupIds Identifiers of the security groups for the image builder or image builder.
 * @property subnetIds Identifier of the subnet to which a network interface is attached from the image builder instance.
 */
public data class ImageBuilderVpcConfig(
    public val securityGroupIds: List<String>? = null,
    public val subnetIds: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appstream.outputs.ImageBuilderVpcConfig):
            ImageBuilderVpcConfig = ImageBuilderVpcConfig(
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
        )
    }
}
