@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property endpointType Type of the interface endpoint.
 * See the [`AccessEndpoint` AWS API documentation](https://docs.aws.amazon.com/appstream2/latest/APIReference/API_AccessEndpoint.html) for valid values.
 * @property vpceId ID of the VPC in which the interface endpoint is used.
 */
public data class StackAccessEndpoint(
    public val endpointType: String,
    public val vpceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appstream.outputs.StackAccessEndpoint):
            StackAccessEndpoint = StackAccessEndpoint(
            endpointType = javaType.endpointType(),
            vpceId = javaType.vpceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
