@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property connectorType Type of storage connector.
 * Valid values are `HOMEFOLDERS`, `GOOGLE_DRIVE`, or `ONE_DRIVE`.
 * @property domains Names of the domains for the account.
 * @property resourceIdentifier ARN of the storage connector.
 */
public data class StackStorageConnector(
    public val connectorType: String,
    public val domains: List<String>? = null,
    public val resourceIdentifier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appstream.outputs.StackStorageConnector):
            StackStorageConnector = StackStorageConnector(
            connectorType = javaType.connectorType(),
            domains = javaType.domains().map({ args0 -> args0 }),
            resourceIdentifier = javaType.resourceIdentifier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
