@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ApiCache].
 */
@PulumiTagMarker
public class ApiCacheResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApiCacheArgs = ApiCacheArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApiCacheArgsBuilder.() -> Unit) {
        val builder = ApiCacheArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ApiCache {
        val builtJavaResource = com.pulumi.aws.appsync.ApiCache(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ApiCache(builtJavaResource)
    }
}

/**
 * Provides an AppSync API Cache.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.GraphQLApi;
 * import com.pulumi.aws.appsync.GraphQLApiArgs;
 * import com.pulumi.aws.appsync.ApiCache;
 * import com.pulumi.aws.appsync.ApiCacheArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGraphQLApi = new GraphQLApi("exampleGraphQLApi", GraphQLApiArgs.builder()
 *             .authenticationType("API_KEY")
 *             .build());
 *         var exampleApiCache = new ApiCache("exampleApiCache", ApiCacheArgs.builder()
 *             .apiId(exampleGraphQLApi.id())
 *             .apiCachingBehavior("FULL_REQUEST_CACHING")
 *             .type("LARGE")
 *             .ttl(900)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_appsync_api_cache` using the AppSync API ID. For example:
 * ```sh
 *  $ pulumi import aws:appsync/apiCache:ApiCache example xxxxx
 * ```
 *
 */
public class ApiCache internal constructor(
    override val javaResource: com.pulumi.aws.appsync.ApiCache,
) : KotlinCustomResource(javaResource, ApiCacheMapper) {
    /**
     * Caching behavior. Valid values are `FULL_REQUEST_CACHING` and `PER_RESOLVER_CACHING`.
     */
    public val apiCachingBehavior: Output<String>
        get() = javaResource.apiCachingBehavior().applyValue({ args0 -> args0 })

    /**
     * GraphQL API ID.
     */
    public val apiId: Output<String>
        get() = javaResource.apiId().applyValue({ args0 -> args0 })

    /**
     * At-rest encryption flag for cache. You cannot update this setting after creation.
     */
    public val atRestEncryptionEnabled: Output<Boolean>?
        get() = javaResource.atRestEncryptionEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Transit encryption flag when connecting to cache. You cannot update this setting after creation.
     */
    public val transitEncryptionEnabled: Output<Boolean>?
        get() = javaResource.transitEncryptionEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * TTL in seconds for cache entries.
     */
    public val ttl: Output<Int>
        get() = javaResource.ttl().applyValue({ args0 -> args0 })

    /**
     * Cache instance type. Valid values are `SMALL`, `MEDIUM`, `LARGE`, `XLARGE`, `LARGE_2X`, `LARGE_4X`, `LARGE_8X`, `LARGE_12X`, `T2_SMALL`, `T2_MEDIUM`, `R4_LARGE`, `R4_XLARGE`, `R4_2XLARGE`, `R4_4XLARGE`, `R4_8XLARGE`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ApiCacheMapper : ResourceMapper<ApiCache> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appsync.ApiCache::class == javaResource::class

    override fun map(javaResource: Resource): ApiCache = ApiCache(
        javaResource as
            com.pulumi.aws.appsync.ApiCache,
    )
}

/**
 * @see [ApiCache].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApiCache].
 */
public suspend fun apiCache(name: String, block: suspend ApiCacheResourceBuilder.() -> Unit):
    ApiCache {
    val builder = ApiCacheResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApiCache].
 * @param name The _unique_ name of the resulting resource.
 */
public fun apiCache(name: String): ApiCache {
    val builder = ApiCacheResourceBuilder()
    builder.name(name)
    return builder.build()
}
