@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.aws.appsync.ApiCacheArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an AppSync API Cache.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.GraphQLApi;
 * import com.pulumi.aws.appsync.GraphQLApiArgs;
 * import com.pulumi.aws.appsync.ApiCache;
 * import com.pulumi.aws.appsync.ApiCacheArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGraphQLApi = new GraphQLApi("exampleGraphQLApi", GraphQLApiArgs.builder()
 *             .authenticationType("API_KEY")
 *             .build());
 *         var exampleApiCache = new ApiCache("exampleApiCache", ApiCacheArgs.builder()
 *             .apiId(exampleGraphQLApi.id())
 *             .apiCachingBehavior("FULL_REQUEST_CACHING")
 *             .type("LARGE")
 *             .ttl(900)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_appsync_api_cache` using the AppSync API ID. For example:
 * ```sh
 *  $ pulumi import aws:appsync/apiCache:ApiCache example xxxxx
 * ```
 * @property apiCachingBehavior Caching behavior. Valid values are `FULL_REQUEST_CACHING` and `PER_RESOLVER_CACHING`.
 * @property apiId GraphQL API ID.
 * @property atRestEncryptionEnabled At-rest encryption flag for cache. You cannot update this setting after creation.
 * @property transitEncryptionEnabled Transit encryption flag when connecting to cache. You cannot update this setting after creation.
 * @property ttl TTL in seconds for cache entries.
 * @property type Cache instance type. Valid values are `SMALL`, `MEDIUM`, `LARGE`, `XLARGE`, `LARGE_2X`, `LARGE_4X`, `LARGE_8X`, `LARGE_12X`, `T2_SMALL`, `T2_MEDIUM`, `R4_LARGE`, `R4_XLARGE`, `R4_2XLARGE`, `R4_4XLARGE`, `R4_8XLARGE`.
 */
public data class ApiCacheArgs(
    public val apiCachingBehavior: Output<String>? = null,
    public val apiId: Output<String>? = null,
    public val atRestEncryptionEnabled: Output<Boolean>? = null,
    public val transitEncryptionEnabled: Output<Boolean>? = null,
    public val ttl: Output<Int>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appsync.ApiCacheArgs> {
    override fun toJava(): com.pulumi.aws.appsync.ApiCacheArgs =
        com.pulumi.aws.appsync.ApiCacheArgs.builder()
            .apiCachingBehavior(apiCachingBehavior?.applyValue({ args0 -> args0 }))
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .atRestEncryptionEnabled(atRestEncryptionEnabled?.applyValue({ args0 -> args0 }))
            .transitEncryptionEnabled(transitEncryptionEnabled?.applyValue({ args0 -> args0 }))
            .ttl(ttl?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiCacheArgs].
 */
@PulumiTagMarker
public class ApiCacheArgsBuilder internal constructor() {
    private var apiCachingBehavior: Output<String>? = null

    private var apiId: Output<String>? = null

    private var atRestEncryptionEnabled: Output<Boolean>? = null

    private var transitEncryptionEnabled: Output<Boolean>? = null

    private var ttl: Output<Int>? = null

    private var type: Output<String>? = null

    /**
     * @param value Caching behavior. Valid values are `FULL_REQUEST_CACHING` and `PER_RESOLVER_CACHING`.
     */
    @JvmName("ddodfuakjplyjbrf")
    public suspend fun apiCachingBehavior(`value`: Output<String>) {
        this.apiCachingBehavior = value
    }

    /**
     * @param value GraphQL API ID.
     */
    @JvmName("hwtdwlytntrpvshk")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value At-rest encryption flag for cache. You cannot update this setting after creation.
     */
    @JvmName("mtnwndxygmtwwtjp")
    public suspend fun atRestEncryptionEnabled(`value`: Output<Boolean>) {
        this.atRestEncryptionEnabled = value
    }

    /**
     * @param value Transit encryption flag when connecting to cache. You cannot update this setting after creation.
     */
    @JvmName("gcjtwklhegoeacbl")
    public suspend fun transitEncryptionEnabled(`value`: Output<Boolean>) {
        this.transitEncryptionEnabled = value
    }

    /**
     * @param value TTL in seconds for cache entries.
     */
    @JvmName("yveitbowejqvgqpc")
    public suspend fun ttl(`value`: Output<Int>) {
        this.ttl = value
    }

    /**
     * @param value Cache instance type. Valid values are `SMALL`, `MEDIUM`, `LARGE`, `XLARGE`, `LARGE_2X`, `LARGE_4X`, `LARGE_8X`, `LARGE_12X`, `T2_SMALL`, `T2_MEDIUM`, `R4_LARGE`, `R4_XLARGE`, `R4_2XLARGE`, `R4_4XLARGE`, `R4_8XLARGE`.
     */
    @JvmName("wygaovhcvxxlgveh")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Caching behavior. Valid values are `FULL_REQUEST_CACHING` and `PER_RESOLVER_CACHING`.
     */
    @JvmName("rkxlarpcttvwjcyx")
    public suspend fun apiCachingBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiCachingBehavior = mapped
    }

    /**
     * @param value GraphQL API ID.
     */
    @JvmName("skinryxdbiscptsl")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value At-rest encryption flag for cache. You cannot update this setting after creation.
     */
    @JvmName("eqluxjahpsetwlxr")
    public suspend fun atRestEncryptionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.atRestEncryptionEnabled = mapped
    }

    /**
     * @param value Transit encryption flag when connecting to cache. You cannot update this setting after creation.
     */
    @JvmName("jnidtlwpsspqisjf")
    public suspend fun transitEncryptionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitEncryptionEnabled = mapped
    }

    /**
     * @param value TTL in seconds for cache entries.
     */
    @JvmName("hspxlffpmdiitpev")
    public suspend fun ttl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ttl = mapped
    }

    /**
     * @param value Cache instance type. Valid values are `SMALL`, `MEDIUM`, `LARGE`, `XLARGE`, `LARGE_2X`, `LARGE_4X`, `LARGE_8X`, `LARGE_12X`, `T2_SMALL`, `T2_MEDIUM`, `R4_LARGE`, `R4_XLARGE`, `R4_2XLARGE`, `R4_4XLARGE`, `R4_8XLARGE`.
     */
    @JvmName("ckgyrhkrgtkowfjs")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ApiCacheArgs = ApiCacheArgs(
        apiCachingBehavior = apiCachingBehavior,
        apiId = apiId,
        atRestEncryptionEnabled = atRestEncryptionEnabled,
        transitEncryptionEnabled = transitEncryptionEnabled,
        ttl = ttl,
        type = type,
    )
}
