@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ApiKey].
 */
@PulumiTagMarker
public class ApiKeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApiKeyArgs = ApiKeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApiKeyArgsBuilder.() -> Unit) {
        val builder = ApiKeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ApiKey {
        val builtJavaResource = com.pulumi.aws.appsync.ApiKey(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ApiKey(builtJavaResource)
    }
}

/**
 * Provides an AppSync API Key.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.GraphQLApi;
 * import com.pulumi.aws.appsync.GraphQLApiArgs;
 * import com.pulumi.aws.appsync.ApiKey;
 * import com.pulumi.aws.appsync.ApiKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGraphQLApi = new GraphQLApi("exampleGraphQLApi", GraphQLApiArgs.builder()
 *             .authenticationType("API_KEY")
 *             .build());
 *         var exampleApiKey = new ApiKey("exampleApiKey", ApiKeyArgs.builder()
 *             .apiId(exampleGraphQLApi.id())
 *             .expires("2018-05-03T04:00:00Z")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_appsync_api_key` using the AppSync API ID and key separated by `:`. For example:
 * ```sh
 *  $ pulumi import aws:appsync/apiKey:ApiKey example xxxxx:yyyyy
 * ```
 *
 */
public class ApiKey internal constructor(
    override val javaResource: com.pulumi.aws.appsync.ApiKey,
) : KotlinCustomResource(javaResource, ApiKeyMapper) {
    /**
     * ID of the associated AppSync API
     */
    public val apiId: Output<String>
        get() = javaResource.apiId().applyValue({ args0 -> args0 })

    /**
     * API key description. Defaults to "Managed by Pulumi".
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * RFC3339 string representation of the expiry date. Rounded down to nearest hour. By default, it is 7 days from the date of creation.
     */
    public val expires: Output<String>?
        get() = javaResource.expires().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * API key
     */
    public val key: Output<String>
        get() = javaResource.key().applyValue({ args0 -> args0 })
}

public object ApiKeyMapper : ResourceMapper<ApiKey> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appsync.ApiKey::class == javaResource::class

    override fun map(javaResource: Resource): ApiKey = ApiKey(
        javaResource as
            com.pulumi.aws.appsync.ApiKey,
    )
}

/**
 * @see [ApiKey].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApiKey].
 */
public suspend fun apiKey(name: String, block: suspend ApiKeyResourceBuilder.() -> Unit): ApiKey {
    val builder = ApiKeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApiKey].
 * @param name The _unique_ name of the resulting resource.
 */
public fun apiKey(name: String): ApiKey {
    val builder = ApiKeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
