@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.aws.appsync.ApiKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an AppSync API Key.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.GraphQLApi;
 * import com.pulumi.aws.appsync.GraphQLApiArgs;
 * import com.pulumi.aws.appsync.ApiKey;
 * import com.pulumi.aws.appsync.ApiKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGraphQLApi = new GraphQLApi("exampleGraphQLApi", GraphQLApiArgs.builder()
 *             .authenticationType("API_KEY")
 *             .build());
 *         var exampleApiKey = new ApiKey("exampleApiKey", ApiKeyArgs.builder()
 *             .apiId(exampleGraphQLApi.id())
 *             .expires("2018-05-03T04:00:00Z")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_appsync_api_key` using the AppSync API ID and key separated by `:`. For example:
 * ```sh
 *  $ pulumi import aws:appsync/apiKey:ApiKey example xxxxx:yyyyy
 * ```
 * @property apiId ID of the associated AppSync API
 * @property description API key description. Defaults to "Managed by Pulumi".
 * @property expires RFC3339 string representation of the expiry date. Rounded down to nearest hour. By default, it is 7 days from the date of creation.
 */
public data class ApiKeyArgs(
    public val apiId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val expires: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appsync.ApiKeyArgs> {
    override fun toJava(): com.pulumi.aws.appsync.ApiKeyArgs =
        com.pulumi.aws.appsync.ApiKeyArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .expires(expires?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiKeyArgs].
 */
@PulumiTagMarker
public class ApiKeyArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var description: Output<String>? = null

    private var expires: Output<String>? = null

    /**
     * @param value ID of the associated AppSync API
     */
    @JvmName("yfokklmansscwbld")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value API key description. Defaults to "Managed by Pulumi".
     */
    @JvmName("pmphcfcqyftjvbql")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value RFC3339 string representation of the expiry date. Rounded down to nearest hour. By default, it is 7 days from the date of creation.
     */
    @JvmName("khwaanhejfynkyka")
    public suspend fun expires(`value`: Output<String>) {
        this.expires = value
    }

    /**
     * @param value ID of the associated AppSync API
     */
    @JvmName("hqspqvribwvvgxpc")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value API key description. Defaults to "Managed by Pulumi".
     */
    @JvmName("rnkyhdljwlfxyuhu")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value RFC3339 string representation of the expiry date. Rounded down to nearest hour. By default, it is 7 days from the date of creation.
     */
    @JvmName("wgdjmlejlvtdqqqo")
    public suspend fun expires(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expires = mapped
    }

    internal fun build(): ApiKeyArgs = ApiKeyArgs(
        apiId = apiId,
        description = description,
        expires = expires,
    )
}
