@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.aws.appsync.kotlin.outputs.DataSourceDynamodbConfig
import com.pulumi.aws.appsync.kotlin.outputs.DataSourceElasticsearchConfig
import com.pulumi.aws.appsync.kotlin.outputs.DataSourceEventBridgeConfig
import com.pulumi.aws.appsync.kotlin.outputs.DataSourceHttpConfig
import com.pulumi.aws.appsync.kotlin.outputs.DataSourceLambdaConfig
import com.pulumi.aws.appsync.kotlin.outputs.DataSourceOpensearchserviceConfig
import com.pulumi.aws.appsync.kotlin.outputs.DataSourceRelationalDatabaseConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.appsync.kotlin.outputs.DataSourceDynamodbConfig.Companion.toKotlin as dataSourceDynamodbConfigToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.DataSourceElasticsearchConfig.Companion.toKotlin as dataSourceElasticsearchConfigToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.DataSourceEventBridgeConfig.Companion.toKotlin as dataSourceEventBridgeConfigToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.DataSourceHttpConfig.Companion.toKotlin as dataSourceHttpConfigToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.DataSourceLambdaConfig.Companion.toKotlin as dataSourceLambdaConfigToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.DataSourceOpensearchserviceConfig.Companion.toKotlin as dataSourceOpensearchserviceConfigToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.DataSourceRelationalDatabaseConfig.Companion.toKotlin as dataSourceRelationalDatabaseConfigToKotlin

/**
 * Builder for [DataSource].
 */
@PulumiTagMarker
public class DataSourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataSourceArgs = DataSourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataSourceArgsBuilder.() -> Unit) {
        val builder = DataSourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DataSource {
        val builtJavaResource = com.pulumi.aws.appsync.DataSource(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DataSource(builtJavaResource)
    }
}

/**
 * Provides an AppSync Data Source.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dynamodb.Table;
 * import com.pulumi.aws.dynamodb.TableArgs;
 * import com.pulumi.aws.dynamodb.inputs.TableAttributeArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.aws.appsync.GraphQLApi;
 * import com.pulumi.aws.appsync.GraphQLApiArgs;
 * import com.pulumi.aws.appsync.DataSource;
 * import com.pulumi.aws.appsync.DataSourceArgs;
 * import com.pulumi.aws.appsync.inputs.DataSourceDynamodbConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleTable = new Table("exampleTable", TableArgs.builder()
 *             .readCapacity(1)
 *             .writeCapacity(1)
 *             .hashKey("UserId")
 *             .attributes(TableAttributeArgs.builder()
 *                 .name("UserId")
 *                 .type("S")
 *                 .build())
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("appsync.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("dynamodb:*")
 *                 .resources(exampleTable.arn())
 *                 .build())
 *             .build());
 *         var exampleRolePolicy = new RolePolicy("exampleRolePolicy", RolePolicyArgs.builder()
 *             .role(exampleRole.id())
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(examplePolicyDocument -> examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var exampleGraphQLApi = new GraphQLApi("exampleGraphQLApi", GraphQLApiArgs.builder()
 *             .authenticationType("API_KEY")
 *             .build());
 *         var exampleDataSource = new DataSource("exampleDataSource", DataSourceArgs.builder()
 *             .apiId(exampleGraphQLApi.id())
 *             .name("my_appsync_example")
 *             .serviceRoleArn(exampleRole.arn())
 *             .type("AMAZON_DYNAMODB")
 *             .dynamodbConfig(DataSourceDynamodbConfigArgs.builder()
 *                 .tableName(exampleTable.name())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_appsync_datasource` using the `api_id`, a hyphen, and `name`. For example:
 * ```sh
 *  $ pulumi import aws:appsync/dataSource:DataSource example abcdef123456-example
 * ```
 *
 */
public class DataSource internal constructor(
    override val javaResource: com.pulumi.aws.appsync.DataSource,
) : KotlinCustomResource(javaResource, DataSourceMapper) {
    /**
     * API ID for the GraphQL API for the data source.
     */
    public val apiId: Output<String>
        get() = javaResource.apiId().applyValue({ args0 -> args0 })

    /**
     * ARN
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Description of the data source.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * DynamoDB settings. See DynamoDB Config
     */
    public val dynamodbConfig: Output<DataSourceDynamodbConfig>?
        get() = javaResource.dynamodbConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dataSourceDynamodbConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Amazon Elasticsearch settings. See ElasticSearch Config
     */
    public val elasticsearchConfig: Output<DataSourceElasticsearchConfig>?
        get() = javaResource.elasticsearchConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dataSourceElasticsearchConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * AWS EventBridge settings. See Event Bridge Config
     */
    public val eventBridgeConfig: Output<DataSourceEventBridgeConfig>?
        get() = javaResource.eventBridgeConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dataSourceEventBridgeConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * HTTP settings. See HTTP Config
     */
    public val httpConfig: Output<DataSourceHttpConfig>?
        get() = javaResource.httpConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dataSourceHttpConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * AWS Lambda settings. See Lambda Config
     */
    public val lambdaConfig: Output<DataSourceLambdaConfig>?
        get() = javaResource.lambdaConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dataSourceLambdaConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * User-supplied name for the data source.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Amazon OpenSearch Service settings. See OpenSearch Service Config
     */
    public val opensearchserviceConfig: Output<DataSourceOpensearchserviceConfig>?
        get() = javaResource.opensearchserviceConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dataSourceOpensearchserviceConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * AWS RDS settings. See Relational Database Config
     */
    public val relationalDatabaseConfig: Output<DataSourceRelationalDatabaseConfig>?
        get() = javaResource.relationalDatabaseConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dataSourceRelationalDatabaseConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * IAM service role ARN for the data source. Required if `type` is specified as `AWS_LAMBDA`, `AMAZON_DYNAMODB`, `AMAZON_ELASTICSEARCH`, `AMAZON_EVENTBRIDGE`, or `AMAZON_OPENSEARCH_SERVICE`.
     */
    public val serviceRoleArn: Output<String>?
        get() = javaResource.serviceRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Type of the Data Source. Valid values: `AWS_LAMBDA`, `AMAZON_DYNAMODB`, `AMAZON_ELASTICSEARCH`, `HTTP`, `NONE`, `RELATIONAL_DATABASE`, `AMAZON_EVENTBRIDGE`, `AMAZON_OPENSEARCH_SERVICE`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DataSourceMapper : ResourceMapper<DataSource> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appsync.DataSource::class == javaResource::class

    override fun map(javaResource: Resource): DataSource = DataSource(
        javaResource as
            com.pulumi.aws.appsync.DataSource,
    )
}

/**
 * @see [DataSource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataSource].
 */
public suspend fun dataSource(name: String, block: suspend DataSourceResourceBuilder.() -> Unit):
    DataSource {
    val builder = DataSourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataSource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataSource(name: String): DataSource {
    val builder = DataSourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
