@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.aws.appsync.DataSourceArgs.builder
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceDynamodbConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceDynamodbConfigArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceElasticsearchConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceElasticsearchConfigArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceEventBridgeConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceEventBridgeConfigArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceHttpConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceHttpConfigArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceLambdaConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceLambdaConfigArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceOpensearchserviceConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceOpensearchserviceConfigArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceRelationalDatabaseConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.DataSourceRelationalDatabaseConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an AppSync Data Source.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dynamodb.Table;
 * import com.pulumi.aws.dynamodb.TableArgs;
 * import com.pulumi.aws.dynamodb.inputs.TableAttributeArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.aws.appsync.GraphQLApi;
 * import com.pulumi.aws.appsync.GraphQLApiArgs;
 * import com.pulumi.aws.appsync.DataSource;
 * import com.pulumi.aws.appsync.DataSourceArgs;
 * import com.pulumi.aws.appsync.inputs.DataSourceDynamodbConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleTable = new Table("exampleTable", TableArgs.builder()
 *             .readCapacity(1)
 *             .writeCapacity(1)
 *             .hashKey("UserId")
 *             .attributes(TableAttributeArgs.builder()
 *                 .name("UserId")
 *                 .type("S")
 *                 .build())
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("appsync.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("dynamodb:*")
 *                 .resources(exampleTable.arn())
 *                 .build())
 *             .build());
 *         var exampleRolePolicy = new RolePolicy("exampleRolePolicy", RolePolicyArgs.builder()
 *             .role(exampleRole.id())
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(examplePolicyDocument -> examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var exampleGraphQLApi = new GraphQLApi("exampleGraphQLApi", GraphQLApiArgs.builder()
 *             .authenticationType("API_KEY")
 *             .build());
 *         var exampleDataSource = new DataSource("exampleDataSource", DataSourceArgs.builder()
 *             .apiId(exampleGraphQLApi.id())
 *             .name("my_appsync_example")
 *             .serviceRoleArn(exampleRole.arn())
 *             .type("AMAZON_DYNAMODB")
 *             .dynamodbConfig(DataSourceDynamodbConfigArgs.builder()
 *                 .tableName(exampleTable.name())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_appsync_datasource` using the `api_id`, a hyphen, and `name`. For example:
 * ```sh
 *  $ pulumi import aws:appsync/dataSource:DataSource example abcdef123456-example
 * ```
 * @property apiId API ID for the GraphQL API for the data source.
 * @property description Description of the data source.
 * @property dynamodbConfig DynamoDB settings. See DynamoDB Config
 * @property elasticsearchConfig Amazon Elasticsearch settings. See ElasticSearch Config
 * @property eventBridgeConfig AWS EventBridge settings. See Event Bridge Config
 * @property httpConfig HTTP settings. See HTTP Config
 * @property lambdaConfig AWS Lambda settings. See Lambda Config
 * @property name User-supplied name for the data source.
 * @property opensearchserviceConfig Amazon OpenSearch Service settings. See OpenSearch Service Config
 * @property relationalDatabaseConfig AWS RDS settings. See Relational Database Config
 * @property serviceRoleArn IAM service role ARN for the data source. Required if `type` is specified as `AWS_LAMBDA`, `AMAZON_DYNAMODB`, `AMAZON_ELASTICSEARCH`, `AMAZON_EVENTBRIDGE`, or `AMAZON_OPENSEARCH_SERVICE`.
 * @property type Type of the Data Source. Valid values: `AWS_LAMBDA`, `AMAZON_DYNAMODB`, `AMAZON_ELASTICSEARCH`, `HTTP`, `NONE`, `RELATIONAL_DATABASE`, `AMAZON_EVENTBRIDGE`, `AMAZON_OPENSEARCH_SERVICE`.
 */
public data class DataSourceArgs(
    public val apiId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val dynamodbConfig: Output<DataSourceDynamodbConfigArgs>? = null,
    public val elasticsearchConfig: Output<DataSourceElasticsearchConfigArgs>? = null,
    public val eventBridgeConfig: Output<DataSourceEventBridgeConfigArgs>? = null,
    public val httpConfig: Output<DataSourceHttpConfigArgs>? = null,
    public val lambdaConfig: Output<DataSourceLambdaConfigArgs>? = null,
    public val name: Output<String>? = null,
    public val opensearchserviceConfig: Output<DataSourceOpensearchserviceConfigArgs>? = null,
    public val relationalDatabaseConfig: Output<DataSourceRelationalDatabaseConfigArgs>? = null,
    public val serviceRoleArn: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appsync.DataSourceArgs> {
    override fun toJava(): com.pulumi.aws.appsync.DataSourceArgs =
        com.pulumi.aws.appsync.DataSourceArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .dynamodbConfig(dynamodbConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .elasticsearchConfig(
                elasticsearchConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .eventBridgeConfig(eventBridgeConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .httpConfig(httpConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .lambdaConfig(lambdaConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .opensearchserviceConfig(
                opensearchserviceConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .relationalDatabaseConfig(
                relationalDatabaseConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .serviceRoleArn(serviceRoleArn?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceArgs].
 */
@PulumiTagMarker
public class DataSourceArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var description: Output<String>? = null

    private var dynamodbConfig: Output<DataSourceDynamodbConfigArgs>? = null

    private var elasticsearchConfig: Output<DataSourceElasticsearchConfigArgs>? = null

    private var eventBridgeConfig: Output<DataSourceEventBridgeConfigArgs>? = null

    private var httpConfig: Output<DataSourceHttpConfigArgs>? = null

    private var lambdaConfig: Output<DataSourceLambdaConfigArgs>? = null

    private var name: Output<String>? = null

    private var opensearchserviceConfig: Output<DataSourceOpensearchserviceConfigArgs>? = null

    private var relationalDatabaseConfig: Output<DataSourceRelationalDatabaseConfigArgs>? = null

    private var serviceRoleArn: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value API ID for the GraphQL API for the data source.
     */
    @JvmName("wwrgibgimbufyavb")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Description of the data source.
     */
    @JvmName("atcwqisivcqstlla")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value DynamoDB settings. See DynamoDB Config
     */
    @JvmName("eohwsefvlhkltivn")
    public suspend fun dynamodbConfig(`value`: Output<DataSourceDynamodbConfigArgs>) {
        this.dynamodbConfig = value
    }

    /**
     * @param value Amazon Elasticsearch settings. See ElasticSearch Config
     */
    @JvmName("jtrqgbwbivxhbxmu")
    public suspend fun elasticsearchConfig(`value`: Output<DataSourceElasticsearchConfigArgs>) {
        this.elasticsearchConfig = value
    }

    /**
     * @param value AWS EventBridge settings. See Event Bridge Config
     */
    @JvmName("idrgrfvrgxkgshjc")
    public suspend fun eventBridgeConfig(`value`: Output<DataSourceEventBridgeConfigArgs>) {
        this.eventBridgeConfig = value
    }

    /**
     * @param value HTTP settings. See HTTP Config
     */
    @JvmName("hjifxohdktdarfrd")
    public suspend fun httpConfig(`value`: Output<DataSourceHttpConfigArgs>) {
        this.httpConfig = value
    }

    /**
     * @param value AWS Lambda settings. See Lambda Config
     */
    @JvmName("uvfauwfsejrpetjm")
    public suspend fun lambdaConfig(`value`: Output<DataSourceLambdaConfigArgs>) {
        this.lambdaConfig = value
    }

    /**
     * @param value User-supplied name for the data source.
     */
    @JvmName("okmhpunaewpsuvbl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Amazon OpenSearch Service settings. See OpenSearch Service Config
     */
    @JvmName("udltymwyppxultwm")
    public suspend
    fun opensearchserviceConfig(`value`: Output<DataSourceOpensearchserviceConfigArgs>) {
        this.opensearchserviceConfig = value
    }

    /**
     * @param value AWS RDS settings. See Relational Database Config
     */
    @JvmName("gyqkesaebdiywhhg")
    public suspend
    fun relationalDatabaseConfig(`value`: Output<DataSourceRelationalDatabaseConfigArgs>) {
        this.relationalDatabaseConfig = value
    }

    /**
     * @param value IAM service role ARN for the data source. Required if `type` is specified as `AWS_LAMBDA`, `AMAZON_DYNAMODB`, `AMAZON_ELASTICSEARCH`, `AMAZON_EVENTBRIDGE`, or `AMAZON_OPENSEARCH_SERVICE`.
     */
    @JvmName("tpowsyocmcqifqoe")
    public suspend fun serviceRoleArn(`value`: Output<String>) {
        this.serviceRoleArn = value
    }

    /**
     * @param value Type of the Data Source. Valid values: `AWS_LAMBDA`, `AMAZON_DYNAMODB`, `AMAZON_ELASTICSEARCH`, `HTTP`, `NONE`, `RELATIONAL_DATABASE`, `AMAZON_EVENTBRIDGE`, `AMAZON_OPENSEARCH_SERVICE`.
     */
    @JvmName("aabhnycptdjnbgfe")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value API ID for the GraphQL API for the data source.
     */
    @JvmName("jeyywgwsdyhwworn")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Description of the data source.
     */
    @JvmName("rtutmcokuxcijolr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value DynamoDB settings. See DynamoDB Config
     */
    @JvmName("uaclqkymnqgxosqw")
    public suspend fun dynamodbConfig(`value`: DataSourceDynamodbConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynamodbConfig = mapped
    }

    /**
     * @param argument DynamoDB settings. See DynamoDB Config
     */
    @JvmName("ctuvfbuvkbbhvapp")
    public suspend
    fun dynamodbConfig(argument: suspend DataSourceDynamodbConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceDynamodbConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dynamodbConfig = mapped
    }

    /**
     * @param value Amazon Elasticsearch settings. See ElasticSearch Config
     */
    @JvmName("rmajjoavnmqdvgen")
    public suspend fun elasticsearchConfig(`value`: DataSourceElasticsearchConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearchConfig = mapped
    }

    /**
     * @param argument Amazon Elasticsearch settings. See ElasticSearch Config
     */
    @JvmName("bcablxbvvuhvksps")
    public suspend
    fun elasticsearchConfig(argument: suspend DataSourceElasticsearchConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceElasticsearchConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.elasticsearchConfig = mapped
    }

    /**
     * @param value AWS EventBridge settings. See Event Bridge Config
     */
    @JvmName("feduptaiwqpplmmc")
    public suspend fun eventBridgeConfig(`value`: DataSourceEventBridgeConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventBridgeConfig = mapped
    }

    /**
     * @param argument AWS EventBridge settings. See Event Bridge Config
     */
    @JvmName("rkbnvcyjoyyicnpe")
    public suspend
    fun eventBridgeConfig(argument: suspend DataSourceEventBridgeConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceEventBridgeConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.eventBridgeConfig = mapped
    }

    /**
     * @param value HTTP settings. See HTTP Config
     */
    @JvmName("mrxtslxlvcdbbycq")
    public suspend fun httpConfig(`value`: DataSourceHttpConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpConfig = mapped
    }

    /**
     * @param argument HTTP settings. See HTTP Config
     */
    @JvmName("guomtawkckjyucph")
    public suspend fun httpConfig(argument: suspend DataSourceHttpConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceHttpConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpConfig = mapped
    }

    /**
     * @param value AWS Lambda settings. See Lambda Config
     */
    @JvmName("ijvggmhwwcgvixps")
    public suspend fun lambdaConfig(`value`: DataSourceLambdaConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdaConfig = mapped
    }

    /**
     * @param argument AWS Lambda settings. See Lambda Config
     */
    @JvmName("flpvbsmxonredodl")
    public suspend fun lambdaConfig(argument: suspend DataSourceLambdaConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceLambdaConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.lambdaConfig = mapped
    }

    /**
     * @param value User-supplied name for the data source.
     */
    @JvmName("ckniuxmjtlewjgfx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Amazon OpenSearch Service settings. See OpenSearch Service Config
     */
    @JvmName("gohrwfoodccqrfik")
    public suspend fun opensearchserviceConfig(`value`: DataSourceOpensearchserviceConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.opensearchserviceConfig = mapped
    }

    /**
     * @param argument Amazon OpenSearch Service settings. See OpenSearch Service Config
     */
    @JvmName("okgomulpfuokkxgm")
    public suspend
    fun opensearchserviceConfig(argument: suspend DataSourceOpensearchserviceConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceOpensearchserviceConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.opensearchserviceConfig = mapped
    }

    /**
     * @param value AWS RDS settings. See Relational Database Config
     */
    @JvmName("rqrxwfwtytstngse")
    public suspend fun relationalDatabaseConfig(`value`: DataSourceRelationalDatabaseConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relationalDatabaseConfig = mapped
    }

    /**
     * @param argument AWS RDS settings. See Relational Database Config
     */
    @JvmName("hepnydnoqwnutxok")
    public suspend
    fun relationalDatabaseConfig(argument: suspend DataSourceRelationalDatabaseConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceRelationalDatabaseConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.relationalDatabaseConfig = mapped
    }

    /**
     * @param value IAM service role ARN for the data source. Required if `type` is specified as `AWS_LAMBDA`, `AMAZON_DYNAMODB`, `AMAZON_ELASTICSEARCH`, `AMAZON_EVENTBRIDGE`, or `AMAZON_OPENSEARCH_SERVICE`.
     */
    @JvmName("vshcalhdckdqyrxw")
    public suspend fun serviceRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceRoleArn = mapped
    }

    /**
     * @param value Type of the Data Source. Valid values: `AWS_LAMBDA`, `AMAZON_DYNAMODB`, `AMAZON_ELASTICSEARCH`, `HTTP`, `NONE`, `RELATIONAL_DATABASE`, `AMAZON_EVENTBRIDGE`, `AMAZON_OPENSEARCH_SERVICE`.
     */
    @JvmName("wmeaeuqvwxapcmri")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DataSourceArgs = DataSourceArgs(
        apiId = apiId,
        description = description,
        dynamodbConfig = dynamodbConfig,
        elasticsearchConfig = elasticsearchConfig,
        eventBridgeConfig = eventBridgeConfig,
        httpConfig = httpConfig,
        lambdaConfig = lambdaConfig,
        name = name,
        opensearchserviceConfig = opensearchserviceConfig,
        relationalDatabaseConfig = relationalDatabaseConfig,
        serviceRoleArn = serviceRoleArn,
        type = type,
    )
}
