@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DomainName].
 */
@PulumiTagMarker
public class DomainNameResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainNameArgs = DomainNameArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainNameArgsBuilder.() -> Unit) {
        val builder = DomainNameArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DomainName {
        val builtJavaResource = com.pulumi.aws.appsync.DomainName(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DomainName(builtJavaResource)
    }
}

/**
 * Provides an AppSync Domain Name.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.DomainName;
 * import com.pulumi.aws.appsync.DomainNameArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DomainName("example", DomainNameArgs.builder()
 *             .domainName("api.example.com")
 *             .certificateArn(aws_acm_certificate.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_appsync_domain_name` using the AppSync domain name. For example:
 * ```sh
 *  $ pulumi import aws:appsync/domainName:DomainName example example.com
 * ```
 *
 */
public class DomainName internal constructor(
    override val javaResource: com.pulumi.aws.appsync.DomainName,
) : KotlinCustomResource(javaResource, DomainNameMapper) {
    /**
     * Domain name that AppSync provides.
     */
    public val appsyncDomainName: Output<String>
        get() = javaResource.appsyncDomainName().applyValue({ args0 -> args0 })

    /**
     * ARN of the certificate. This can be an Certificate Manager (ACM) certificate or an Identity and Access Management (IAM) server certificate. The certifiacte must reside in us-east-1.
     */
    public val certificateArn: Output<String>
        get() = javaResource.certificateArn().applyValue({ args0 -> args0 })

    /**
     * A description of the Domain Name.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Domain name.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * ID of your Amazon Route 53 hosted zone.
     */
    public val hostedZoneId: Output<String>
        get() = javaResource.hostedZoneId().applyValue({ args0 -> args0 })
}

public object DomainNameMapper : ResourceMapper<DomainName> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appsync.DomainName::class == javaResource::class

    override fun map(javaResource: Resource): DomainName = DomainName(
        javaResource as
            com.pulumi.aws.appsync.DomainName,
    )
}

/**
 * @see [DomainName].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DomainName].
 */
public suspend fun domainName(name: String, block: suspend DomainNameResourceBuilder.() -> Unit):
    DomainName {
    val builder = DomainNameResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DomainName].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domainName(name: String): DomainName {
    val builder = DomainNameResourceBuilder()
    builder.name(name)
    return builder.build()
}
