@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.aws.appsync.DomainNameApiAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an AppSync API Association.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.DomainNameApiAssociation;
 * import com.pulumi.aws.appsync.DomainNameApiAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DomainNameApiAssociation("example", DomainNameApiAssociationArgs.builder()
 *             .apiId(aws_appsync_graphql_api.example().id())
 *             .domainName(aws_appsync_domain_name.example().domain_name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_appsync_domain_name_api_association` using the AppSync domain name. For example:
 * ```sh
 *  $ pulumi import aws:appsync/domainNameApiAssociation:DomainNameApiAssociation example example.com
 * ```
 * @property apiId API ID.
 * @property domainName Appsync domain name.
 */
public data class DomainNameApiAssociationArgs(
    public val apiId: Output<String>? = null,
    public val domainName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appsync.DomainNameApiAssociationArgs> {
    override fun toJava(): com.pulumi.aws.appsync.DomainNameApiAssociationArgs =
        com.pulumi.aws.appsync.DomainNameApiAssociationArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainNameApiAssociationArgs].
 */
@PulumiTagMarker
public class DomainNameApiAssociationArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var domainName: Output<String>? = null

    /**
     * @param value API ID.
     */
    @JvmName("jdrfcluyglpkibkf")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Appsync domain name.
     */
    @JvmName("nacjwsjlprrkxbei")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value API ID.
     */
    @JvmName("jdpafmaotdpwoldm")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Appsync domain name.
     */
    @JvmName("iwghhbfhpelpfcea")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    internal fun build(): DomainNameApiAssociationArgs = DomainNameApiAssociationArgs(
        apiId = apiId,
        domainName = domainName,
    )
}
