@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.aws.appsync.FunctionArgs.builder
import com.pulumi.aws.appsync.kotlin.inputs.FunctionRuntimeArgs
import com.pulumi.aws.appsync.kotlin.inputs.FunctionRuntimeArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.FunctionSyncConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.FunctionSyncConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an AppSync Function.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.GraphQLApi;
 * import com.pulumi.aws.appsync.GraphQLApiArgs;
 * import com.pulumi.aws.appsync.DataSource;
 * import com.pulumi.aws.appsync.DataSourceArgs;
 * import com.pulumi.aws.appsync.inputs.DataSourceHttpConfigArgs;
 * import com.pulumi.aws.appsync.Function;
 * import com.pulumi.aws.appsync.FunctionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGraphQLApi = new GraphQLApi("exampleGraphQLApi", GraphQLApiArgs.builder()
 *             .authenticationType("API_KEY")
 *             .schema("""
 * type Mutation {
 *   putPost(id: ID!, title: String!): Post
 * }
 * type Post {
 *   id: ID!
 *   title: String!
 * }
 * type Query {
 *   singlePost(id: ID!): Post
 * }
 * schema {
 *   query: Query
 *   mutation: Mutation
 * }
 *             """)
 *             .build());
 *         var exampleDataSource = new DataSource("exampleDataSource", DataSourceArgs.builder()
 *             .apiId(exampleGraphQLApi.id())
 *             .name("example")
 *             .type("HTTP")
 *             .httpConfig(DataSourceHttpConfigArgs.builder()
 *                 .endpoint("http://example.com")
 *                 .build())
 *             .build());
 *         var exampleFunction = new Function("exampleFunction", FunctionArgs.builder()
 *             .apiId(exampleGraphQLApi.id())
 *             .dataSource(exampleDataSource.name())
 *             .name("example")
 *             .requestMappingTemplate("""
 * {
 *     "version": "2018-05-29",
 *     "method": "GET",
 *     "resourcePath": "/",
 *     "params":{
 *         "headers": $utils.http.copyheaders($ctx.request.headers)
 *     }
 * }
 *             """)
 *             .responseMappingTemplate("""
 * #if($ctx.result.statusCode == 200)
 *     $ctx.result.body
 * #else
 *     $utils.appendError($ctx.result.body, $ctx.result.statusCode)
 * #end
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ### With Code
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.Function;
 * import com.pulumi.aws.appsync.FunctionArgs;
 * import com.pulumi.aws.appsync.inputs.FunctionRuntimeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Function("example", FunctionArgs.builder()
 *             .apiId(aws_appsync_graphql_api.example().id())
 *             .dataSource(aws_appsync_datasource.example().name())
 *             .name("example")
 *             .code(Files.readString(Paths.get("some-code-dir")))
 *             .runtime(FunctionRuntimeArgs.builder()
 *                 .name("APPSYNC_JS")
 *                 .runtimeVersion("1.0.0")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_appsync_function` using the AppSync API ID and Function ID separated by `-`. For example:
 * ```sh
 *  $ pulumi import aws:appsync/function:Function example xxxxx-yyyyy
 * ```
 * @property apiId ID of the associated AppSync API.
 * @property code The function code that contains the request and response functions. When code is used, the runtime is required. The runtime value must be APPSYNC_JS.
 * @property dataSource Function data source name.
 * @property description Function description.
 * @property functionVersion Version of the request mapping template. Currently the supported value is `2018-05-29`. Does not apply when specifying `code`.
 * @property maxBatchSize Maximum batching size for a resolver. Valid values are between `0` and `2000`.
 * @property name Function name. The function name does not have to be unique.
 * @property requestMappingTemplate Function request mapping template. Functions support only the 2018-05-29 version of the request mapping template.
 * @property responseMappingTemplate Function response mapping template.
 * @property runtime Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified. See Runtime.
 * @property syncConfig Describes a Sync configuration for a resolver. See Sync Config.
 */
public data class FunctionArgs(
    public val apiId: Output<String>? = null,
    public val code: Output<String>? = null,
    public val dataSource: Output<String>? = null,
    public val description: Output<String>? = null,
    public val functionVersion: Output<String>? = null,
    public val maxBatchSize: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val requestMappingTemplate: Output<String>? = null,
    public val responseMappingTemplate: Output<String>? = null,
    public val runtime: Output<FunctionRuntimeArgs>? = null,
    public val syncConfig: Output<FunctionSyncConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appsync.FunctionArgs> {
    override fun toJava(): com.pulumi.aws.appsync.FunctionArgs =
        com.pulumi.aws.appsync.FunctionArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .code(code?.applyValue({ args0 -> args0 }))
            .dataSource(dataSource?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .functionVersion(functionVersion?.applyValue({ args0 -> args0 }))
            .maxBatchSize(maxBatchSize?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .requestMappingTemplate(requestMappingTemplate?.applyValue({ args0 -> args0 }))
            .responseMappingTemplate(responseMappingTemplate?.applyValue({ args0 -> args0 }))
            .runtime(runtime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .syncConfig(syncConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FunctionArgs].
 */
@PulumiTagMarker
public class FunctionArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var code: Output<String>? = null

    private var dataSource: Output<String>? = null

    private var description: Output<String>? = null

    private var functionVersion: Output<String>? = null

    private var maxBatchSize: Output<Int>? = null

    private var name: Output<String>? = null

    private var requestMappingTemplate: Output<String>? = null

    private var responseMappingTemplate: Output<String>? = null

    private var runtime: Output<FunctionRuntimeArgs>? = null

    private var syncConfig: Output<FunctionSyncConfigArgs>? = null

    /**
     * @param value ID of the associated AppSync API.
     */
    @JvmName("myuegmnavtdrgvuj")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value The function code that contains the request and response functions. When code is used, the runtime is required. The runtime value must be APPSYNC_JS.
     */
    @JvmName("ubvsjhpayeslycnh")
    public suspend fun code(`value`: Output<String>) {
        this.code = value
    }

    /**
     * @param value Function data source name.
     */
    @JvmName("nwjrygywnqsyjwvi")
    public suspend fun dataSource(`value`: Output<String>) {
        this.dataSource = value
    }

    /**
     * @param value Function description.
     */
    @JvmName("fiojyrtxmtaprvdw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Version of the request mapping template. Currently the supported value is `2018-05-29`. Does not apply when specifying `code`.
     */
    @JvmName("ygdibwaxttteiicg")
    public suspend fun functionVersion(`value`: Output<String>) {
        this.functionVersion = value
    }

    /**
     * @param value Maximum batching size for a resolver. Valid values are between `0` and `2000`.
     */
    @JvmName("phnounywtypqqduh")
    public suspend fun maxBatchSize(`value`: Output<Int>) {
        this.maxBatchSize = value
    }

    /**
     * @param value Function name. The function name does not have to be unique.
     */
    @JvmName("afwoxvuubhrlhuhp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Function request mapping template. Functions support only the 2018-05-29 version of the request mapping template.
     */
    @JvmName("wwxajjaqrfbtfwra")
    public suspend fun requestMappingTemplate(`value`: Output<String>) {
        this.requestMappingTemplate = value
    }

    /**
     * @param value Function response mapping template.
     */
    @JvmName("eyotjrlhneaosvhk")
    public suspend fun responseMappingTemplate(`value`: Output<String>) {
        this.responseMappingTemplate = value
    }

    /**
     * @param value Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified. See Runtime.
     */
    @JvmName("esnsmkbqargwvmry")
    public suspend fun runtime(`value`: Output<FunctionRuntimeArgs>) {
        this.runtime = value
    }

    /**
     * @param value Describes a Sync configuration for a resolver. See Sync Config.
     */
    @JvmName("iwjnthpdoktxssox")
    public suspend fun syncConfig(`value`: Output<FunctionSyncConfigArgs>) {
        this.syncConfig = value
    }

    /**
     * @param value ID of the associated AppSync API.
     */
    @JvmName("xerpcgjbkybemgyk")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value The function code that contains the request and response functions. When code is used, the runtime is required. The runtime value must be APPSYNC_JS.
     */
    @JvmName("kxyjfmviburobjis")
    public suspend fun code(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value Function data source name.
     */
    @JvmName("aktkyxqsxibdwpjr")
    public suspend fun dataSource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSource = mapped
    }

    /**
     * @param value Function description.
     */
    @JvmName("vwwmdltiotvskchx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Version of the request mapping template. Currently the supported value is `2018-05-29`. Does not apply when specifying `code`.
     */
    @JvmName("ijwvhotcpqkmondq")
    public suspend fun functionVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionVersion = mapped
    }

    /**
     * @param value Maximum batching size for a resolver. Valid values are between `0` and `2000`.
     */
    @JvmName("yocseniilsrlrsnf")
    public suspend fun maxBatchSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxBatchSize = mapped
    }

    /**
     * @param value Function name. The function name does not have to be unique.
     */
    @JvmName("pmmsgpylerpecqau")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Function request mapping template. Functions support only the 2018-05-29 version of the request mapping template.
     */
    @JvmName("arfuaacponjqtdhl")
    public suspend fun requestMappingTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestMappingTemplate = mapped
    }

    /**
     * @param value Function response mapping template.
     */
    @JvmName("adjxkrxwjhbgargi")
    public suspend fun responseMappingTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseMappingTemplate = mapped
    }

    /**
     * @param value Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified. See Runtime.
     */
    @JvmName("dpcinqlmqjehurwr")
    public suspend fun runtime(`value`: FunctionRuntimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtime = mapped
    }

    /**
     * @param argument Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified. See Runtime.
     */
    @JvmName("duhqqeapxtrbnosi")
    public suspend fun runtime(argument: suspend FunctionRuntimeArgsBuilder.() -> Unit) {
        val toBeMapped = FunctionRuntimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.runtime = mapped
    }

    /**
     * @param value Describes a Sync configuration for a resolver. See Sync Config.
     */
    @JvmName("dsjjbwomtfmomhaj")
    public suspend fun syncConfig(`value`: FunctionSyncConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncConfig = mapped
    }

    /**
     * @param argument Describes a Sync configuration for a resolver. See Sync Config.
     */
    @JvmName("eefebguixfcfqvhm")
    public suspend fun syncConfig(argument: suspend FunctionSyncConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FunctionSyncConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.syncConfig = mapped
    }

    internal fun build(): FunctionArgs = FunctionArgs(
        apiId = apiId,
        code = code,
        dataSource = dataSource,
        description = description,
        functionVersion = functionVersion,
        maxBatchSize = maxBatchSize,
        name = name,
        requestMappingTemplate = requestMappingTemplate,
        responseMappingTemplate = responseMappingTemplate,
        runtime = runtime,
        syncConfig = syncConfig,
    )
}
