@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.aws.appsync.kotlin.outputs.GraphQLApiAdditionalAuthenticationProvider
import com.pulumi.aws.appsync.kotlin.outputs.GraphQLApiLambdaAuthorizerConfig
import com.pulumi.aws.appsync.kotlin.outputs.GraphQLApiLogConfig
import com.pulumi.aws.appsync.kotlin.outputs.GraphQLApiOpenidConnectConfig
import com.pulumi.aws.appsync.kotlin.outputs.GraphQLApiUserPoolConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.appsync.kotlin.outputs.GraphQLApiAdditionalAuthenticationProvider.Companion.toKotlin as graphQLApiAdditionalAuthenticationProviderToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.GraphQLApiLambdaAuthorizerConfig.Companion.toKotlin as graphQLApiLambdaAuthorizerConfigToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.GraphQLApiLogConfig.Companion.toKotlin as graphQLApiLogConfigToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.GraphQLApiOpenidConnectConfig.Companion.toKotlin as graphQLApiOpenidConnectConfigToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.GraphQLApiUserPoolConfig.Companion.toKotlin as graphQLApiUserPoolConfigToKotlin

/**
 * Builder for [GraphQLApi].
 */
@PulumiTagMarker
public class GraphQLApiResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GraphQLApiArgs = GraphQLApiArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GraphQLApiArgsBuilder.() -> Unit) {
        val builder = GraphQLApiArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): GraphQLApi {
        val builtJavaResource = com.pulumi.aws.appsync.GraphQLApi(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GraphQLApi(builtJavaResource)
    }
}

public class GraphQLApi internal constructor(
    override val javaResource: com.pulumi.aws.appsync.GraphQLApi,
) : KotlinCustomResource(javaResource, GraphQLApiMapper) {
    /**
     * One or more additional authentication providers for the GraphqlApi. Defined below.
     */
    public val additionalAuthenticationProviders:
        Output<List<GraphQLApiAdditionalAuthenticationProvider>>?
        get() = javaResource.additionalAuthenticationProviders().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        graphQLApiAdditionalAuthenticationProviderToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * ARN
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
     */
    public val authenticationType: Output<String>
        get() = javaResource.authenticationType().applyValue({ args0 -> args0 })

    /**
     * Nested argument containing Lambda authorizer configuration. Defined below.
     */
    public val lambdaAuthorizerConfig: Output<GraphQLApiLambdaAuthorizerConfig>?
        get() = javaResource.lambdaAuthorizerConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> graphQLApiLambdaAuthorizerConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Nested argument containing logging configuration. Defined below.
     */
    public val logConfig: Output<GraphQLApiLogConfig>?
        get() = javaResource.logConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    graphQLApiLogConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * User-supplied name for the GraphqlApi.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Nested argument containing OpenID Connect configuration. Defined below.
     */
    public val openidConnectConfig: Output<GraphQLApiOpenidConnectConfig>?
        get() = javaResource.openidConnectConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> graphQLApiOpenidConnectConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Schema definition, in GraphQL schema language format. This provider cannot perform drift detection of this configuration.
     */
    public val schema: Output<String>?
        get() = javaResource.schema().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Map of URIs associated with the APIE.g., `uris["GRAPHQL"] = https://ID.appsync-api.REGION.amazonaws.com/graphql`
     */
    public val uris: Output<Map<String, String>>
        get() = javaResource.uris().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Amazon Cognito User Pool configuration. Defined below.
     */
    public val userPoolConfig: Output<GraphQLApiUserPoolConfig>?
        get() = javaResource.userPoolConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> graphQLApiUserPoolConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Sets the value of the GraphQL API to public (`GLOBAL`) or private (`PRIVATE`). If no value is provided, the visibility will be set to `GLOBAL` by default. This value cannot be changed once the API has been created.
     */
    public val visibility: Output<String>?
        get() = javaResource.visibility().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether tracing with X-ray is enabled. Defaults to false.
     */
    public val xrayEnabled: Output<Boolean>?
        get() = javaResource.xrayEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object GraphQLApiMapper : ResourceMapper<GraphQLApi> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appsync.GraphQLApi::class == javaResource::class

    override fun map(javaResource: Resource): GraphQLApi = GraphQLApi(
        javaResource as
            com.pulumi.aws.appsync.GraphQLApi,
    )
}

/**
 * @see [GraphQLApi].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GraphQLApi].
 */
public suspend fun graphQLApi(name: String, block: suspend GraphQLApiResourceBuilder.() -> Unit):
    GraphQLApi {
    val builder = GraphQLApiResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GraphQLApi].
 * @param name The _unique_ name of the resulting resource.
 */
public fun graphQLApi(name: String): GraphQLApi {
    val builder = GraphQLApiResourceBuilder()
    builder.name(name)
    return builder.build()
}
