@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.aws.appsync.GraphQLApiArgs.builder
import com.pulumi.aws.appsync.kotlin.inputs.GraphQLApiAdditionalAuthenticationProviderArgs
import com.pulumi.aws.appsync.kotlin.inputs.GraphQLApiAdditionalAuthenticationProviderArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.GraphQLApiLambdaAuthorizerConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.GraphQLApiLambdaAuthorizerConfigArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.GraphQLApiLogConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.GraphQLApiLogConfigArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.GraphQLApiOpenidConnectConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.GraphQLApiOpenidConnectConfigArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.GraphQLApiUserPoolConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.GraphQLApiUserPoolConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property additionalAuthenticationProviders One or more additional authentication providers for the GraphqlApi. Defined below.
 * @property authenticationType Authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
 * @property lambdaAuthorizerConfig Nested argument containing Lambda authorizer configuration. Defined below.
 * @property logConfig Nested argument containing logging configuration. Defined below.
 * @property name User-supplied name for the GraphqlApi.
 * @property openidConnectConfig Nested argument containing OpenID Connect configuration. Defined below.
 * @property schema Schema definition, in GraphQL schema language format. This provider cannot perform drift detection of this configuration.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property userPoolConfig Amazon Cognito User Pool configuration. Defined below.
 * @property visibility Sets the value of the GraphQL API to public (`GLOBAL`) or private (`PRIVATE`). If no value is provided, the visibility will be set to `GLOBAL` by default. This value cannot be changed once the API has been created.
 * @property xrayEnabled Whether tracing with X-ray is enabled. Defaults to false.
 */
public data class GraphQLApiArgs(
    public val additionalAuthenticationProviders:
    Output<List<GraphQLApiAdditionalAuthenticationProviderArgs>>? = null,
    public val authenticationType: Output<String>? = null,
    public val lambdaAuthorizerConfig: Output<GraphQLApiLambdaAuthorizerConfigArgs>? = null,
    public val logConfig: Output<GraphQLApiLogConfigArgs>? = null,
    public val name: Output<String>? = null,
    public val openidConnectConfig: Output<GraphQLApiOpenidConnectConfigArgs>? = null,
    public val schema: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userPoolConfig: Output<GraphQLApiUserPoolConfigArgs>? = null,
    public val visibility: Output<String>? = null,
    public val xrayEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.appsync.GraphQLApiArgs> {
    override fun toJava(): com.pulumi.aws.appsync.GraphQLApiArgs =
        com.pulumi.aws.appsync.GraphQLApiArgs.builder()
            .additionalAuthenticationProviders(
                additionalAuthenticationProviders?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .authenticationType(authenticationType?.applyValue({ args0 -> args0 }))
            .lambdaAuthorizerConfig(
                lambdaAuthorizerConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .logConfig(logConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .openidConnectConfig(
                openidConnectConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .schema(schema?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userPoolConfig(userPoolConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .visibility(visibility?.applyValue({ args0 -> args0 }))
            .xrayEnabled(xrayEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GraphQLApiArgs].
 */
@PulumiTagMarker
public class GraphQLApiArgsBuilder internal constructor() {
    private var additionalAuthenticationProviders:
        Output<List<GraphQLApiAdditionalAuthenticationProviderArgs>>? = null

    private var authenticationType: Output<String>? = null

    private var lambdaAuthorizerConfig: Output<GraphQLApiLambdaAuthorizerConfigArgs>? = null

    private var logConfig: Output<GraphQLApiLogConfigArgs>? = null

    private var name: Output<String>? = null

    private var openidConnectConfig: Output<GraphQLApiOpenidConnectConfigArgs>? = null

    private var schema: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userPoolConfig: Output<GraphQLApiUserPoolConfigArgs>? = null

    private var visibility: Output<String>? = null

    private var xrayEnabled: Output<Boolean>? = null

    /**
     * @param value One or more additional authentication providers for the GraphqlApi. Defined below.
     */
    @JvmName("vdfvpgnrkojfbeit")
    public suspend
    fun additionalAuthenticationProviders(`value`: Output<List<GraphQLApiAdditionalAuthenticationProviderArgs>>) {
        this.additionalAuthenticationProviders = value
    }

    @JvmName("nhsgwdnypcfhqkpn")
    public suspend fun additionalAuthenticationProviders(
        vararg
        values: Output<GraphQLApiAdditionalAuthenticationProviderArgs>,
    ) {
        this.additionalAuthenticationProviders = Output.all(values.asList())
    }

    /**
     * @param values One or more additional authentication providers for the GraphqlApi. Defined below.
     */
    @JvmName("nkdbkoumkxoksggm")
    public suspend
    fun additionalAuthenticationProviders(values: List<Output<GraphQLApiAdditionalAuthenticationProviderArgs>>) {
        this.additionalAuthenticationProviders = Output.all(values)
    }

    /**
     * @param value Authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
     */
    @JvmName("mdgtwoxjurhblpqc")
    public suspend fun authenticationType(`value`: Output<String>) {
        this.authenticationType = value
    }

    /**
     * @param value Nested argument containing Lambda authorizer configuration. Defined below.
     */
    @JvmName("doyodjrcdgwcufbb")
    public suspend fun lambdaAuthorizerConfig(`value`: Output<GraphQLApiLambdaAuthorizerConfigArgs>) {
        this.lambdaAuthorizerConfig = value
    }

    /**
     * @param value Nested argument containing logging configuration. Defined below.
     */
    @JvmName("kniksfxglttmiagl")
    public suspend fun logConfig(`value`: Output<GraphQLApiLogConfigArgs>) {
        this.logConfig = value
    }

    /**
     * @param value User-supplied name for the GraphqlApi.
     */
    @JvmName("jtmfplghakpvhkux")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Nested argument containing OpenID Connect configuration. Defined below.
     */
    @JvmName("nrmuejakspbqbhje")
    public suspend fun openidConnectConfig(`value`: Output<GraphQLApiOpenidConnectConfigArgs>) {
        this.openidConnectConfig = value
    }

    /**
     * @param value Schema definition, in GraphQL schema language format. This provider cannot perform drift detection of this configuration.
     */
    @JvmName("ymqyveoklnhmkmlu")
    public suspend fun schema(`value`: Output<String>) {
        this.schema = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ubrnjwumogsiesyx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Amazon Cognito User Pool configuration. Defined below.
     */
    @JvmName("mwkintfqnloimlxl")
    public suspend fun userPoolConfig(`value`: Output<GraphQLApiUserPoolConfigArgs>) {
        this.userPoolConfig = value
    }

    /**
     * @param value Sets the value of the GraphQL API to public (`GLOBAL`) or private (`PRIVATE`). If no value is provided, the visibility will be set to `GLOBAL` by default. This value cannot be changed once the API has been created.
     */
    @JvmName("sefcmjsaaavomkeu")
    public suspend fun visibility(`value`: Output<String>) {
        this.visibility = value
    }

    /**
     * @param value Whether tracing with X-ray is enabled. Defaults to false.
     */
    @JvmName("wpimvrwfiutityws")
    public suspend fun xrayEnabled(`value`: Output<Boolean>) {
        this.xrayEnabled = value
    }

    /**
     * @param value One or more additional authentication providers for the GraphqlApi. Defined below.
     */
    @JvmName("ajoaiyhjpaqrvwvc")
    public suspend
    fun additionalAuthenticationProviders(`value`: List<GraphQLApiAdditionalAuthenticationProviderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalAuthenticationProviders = mapped
    }

    /**
     * @param argument One or more additional authentication providers for the GraphqlApi. Defined below.
     */
    @JvmName("ngvkefwnpgudptee")
    public suspend
    fun additionalAuthenticationProviders(argument: List<suspend GraphQLApiAdditionalAuthenticationProviderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GraphQLApiAdditionalAuthenticationProviderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalAuthenticationProviders = mapped
    }

    /**
     * @param argument One or more additional authentication providers for the GraphqlApi. Defined below.
     */
    @JvmName("ofjxgcfldxfclext")
    public suspend fun additionalAuthenticationProviders(
        vararg
        argument: suspend GraphQLApiAdditionalAuthenticationProviderArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GraphQLApiAdditionalAuthenticationProviderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalAuthenticationProviders = mapped
    }

    /**
     * @param argument One or more additional authentication providers for the GraphqlApi. Defined below.
     */
    @JvmName("ckihyudclcoofgwm")
    public suspend
    fun additionalAuthenticationProviders(argument: suspend GraphQLApiAdditionalAuthenticationProviderArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GraphQLApiAdditionalAuthenticationProviderArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.additionalAuthenticationProviders = mapped
    }

    /**
     * @param values One or more additional authentication providers for the GraphqlApi. Defined below.
     */
    @JvmName("twlnmnfmvjkebxqt")
    public suspend fun additionalAuthenticationProviders(
        vararg
        values: GraphQLApiAdditionalAuthenticationProviderArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalAuthenticationProviders = mapped
    }

    /**
     * @param value Authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
     */
    @JvmName("kycecajneelgvgnw")
    public suspend fun authenticationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Nested argument containing Lambda authorizer configuration. Defined below.
     */
    @JvmName("ayccgojwrqwkrwwl")
    public suspend fun lambdaAuthorizerConfig(`value`: GraphQLApiLambdaAuthorizerConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdaAuthorizerConfig = mapped
    }

    /**
     * @param argument Nested argument containing Lambda authorizer configuration. Defined below.
     */
    @JvmName("sqkbhgcxcnakckfb")
    public suspend
    fun lambdaAuthorizerConfig(argument: suspend GraphQLApiLambdaAuthorizerConfigArgsBuilder.() -> Unit) {
        val toBeMapped = GraphQLApiLambdaAuthorizerConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.lambdaAuthorizerConfig = mapped
    }

    /**
     * @param value Nested argument containing logging configuration. Defined below.
     */
    @JvmName("oxwxbkdttcwrjjom")
    public suspend fun logConfig(`value`: GraphQLApiLogConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logConfig = mapped
    }

    /**
     * @param argument Nested argument containing logging configuration. Defined below.
     */
    @JvmName("lojmscyqwjibvsdx")
    public suspend fun logConfig(argument: suspend GraphQLApiLogConfigArgsBuilder.() -> Unit) {
        val toBeMapped = GraphQLApiLogConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logConfig = mapped
    }

    /**
     * @param value User-supplied name for the GraphqlApi.
     */
    @JvmName("ekgovnptvitaeoxo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Nested argument containing OpenID Connect configuration. Defined below.
     */
    @JvmName("tvbnvwopltefatlp")
    public suspend fun openidConnectConfig(`value`: GraphQLApiOpenidConnectConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.openidConnectConfig = mapped
    }

    /**
     * @param argument Nested argument containing OpenID Connect configuration. Defined below.
     */
    @JvmName("dtlevijwsxrdndhx")
    public suspend
    fun openidConnectConfig(argument: suspend GraphQLApiOpenidConnectConfigArgsBuilder.() -> Unit) {
        val toBeMapped = GraphQLApiOpenidConnectConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.openidConnectConfig = mapped
    }

    /**
     * @param value Schema definition, in GraphQL schema language format. This provider cannot perform drift detection of this configuration.
     */
    @JvmName("ywoljhrjhdrvumka")
    public suspend fun schema(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wxcyqnyvjjfubhpx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bgmoimjbbaqejuxv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Amazon Cognito User Pool configuration. Defined below.
     */
    @JvmName("gkybtmrchawmtukc")
    public suspend fun userPoolConfig(`value`: GraphQLApiUserPoolConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userPoolConfig = mapped
    }

    /**
     * @param argument Amazon Cognito User Pool configuration. Defined below.
     */
    @JvmName("msxmvpwkheqndvvo")
    public suspend
    fun userPoolConfig(argument: suspend GraphQLApiUserPoolConfigArgsBuilder.() -> Unit) {
        val toBeMapped = GraphQLApiUserPoolConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.userPoolConfig = mapped
    }

    /**
     * @param value Sets the value of the GraphQL API to public (`GLOBAL`) or private (`PRIVATE`). If no value is provided, the visibility will be set to `GLOBAL` by default. This value cannot be changed once the API has been created.
     */
    @JvmName("dcrmjgsalodelglb")
    public suspend fun visibility(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.visibility = mapped
    }

    /**
     * @param value Whether tracing with X-ray is enabled. Defaults to false.
     */
    @JvmName("ontsywfvhiapwiwo")
    public suspend fun xrayEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xrayEnabled = mapped
    }

    internal fun build(): GraphQLApiArgs = GraphQLApiArgs(
        additionalAuthenticationProviders = additionalAuthenticationProviders,
        authenticationType = authenticationType,
        lambdaAuthorizerConfig = lambdaAuthorizerConfig,
        logConfig = logConfig,
        name = name,
        openidConnectConfig = openidConnectConfig,
        schema = schema,
        tags = tags,
        userPoolConfig = userPoolConfig,
        visibility = visibility,
        xrayEnabled = xrayEnabled,
    )
}
