@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.aws.appsync.kotlin.outputs.ResolverCachingConfig
import com.pulumi.aws.appsync.kotlin.outputs.ResolverPipelineConfig
import com.pulumi.aws.appsync.kotlin.outputs.ResolverRuntime
import com.pulumi.aws.appsync.kotlin.outputs.ResolverSyncConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.appsync.kotlin.outputs.ResolverCachingConfig.Companion.toKotlin as resolverCachingConfigToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.ResolverPipelineConfig.Companion.toKotlin as resolverPipelineConfigToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.ResolverRuntime.Companion.toKotlin as resolverRuntimeToKotlin
import com.pulumi.aws.appsync.kotlin.outputs.ResolverSyncConfig.Companion.toKotlin as resolverSyncConfigToKotlin

/**
 * Builder for [Resolver].
 */
@PulumiTagMarker
public class ResolverResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResolverArgs = ResolverArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResolverArgsBuilder.() -> Unit) {
        val builder = ResolverArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Resolver {
        val builtJavaResource = com.pulumi.aws.appsync.Resolver(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Resolver(builtJavaResource)
    }
}

/**
 * Provides an AppSync Resolver.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.GraphQLApi;
 * import com.pulumi.aws.appsync.GraphQLApiArgs;
 * import com.pulumi.aws.appsync.DataSource;
 * import com.pulumi.aws.appsync.DataSourceArgs;
 * import com.pulumi.aws.appsync.inputs.DataSourceHttpConfigArgs;
 * import com.pulumi.aws.appsync.Resolver;
 * import com.pulumi.aws.appsync.ResolverArgs;
 * import com.pulumi.aws.appsync.inputs.ResolverCachingConfigArgs;
 * import com.pulumi.aws.appsync.inputs.ResolverPipelineConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testGraphQLApi = new GraphQLApi("testGraphQLApi", GraphQLApiArgs.builder()
 *             .authenticationType("API_KEY")
 *             .schema("""
 * type Mutation {
 * 	putPost(id: ID!, title: String!): Post
 * }
 * type Post {
 * 	id: ID!
 * 	title: String!
 * }
 * type Query {
 * 	singlePost(id: ID!): Post
 * }
 * schema {
 * 	query: Query
 * 	mutation: Mutation
 * }
 *             """)
 *             .build());
 *         var testDataSource = new DataSource("testDataSource", DataSourceArgs.builder()
 *             .apiId(testGraphQLApi.id())
 *             .name("my_example")
 *             .type("HTTP")
 *             .httpConfig(DataSourceHttpConfigArgs.builder()
 *                 .endpoint("http://example.com")
 *                 .build())
 *             .build());
 *         var testResolver = new Resolver("testResolver", ResolverArgs.builder()
 *             .apiId(testGraphQLApi.id())
 *             .field("singlePost")
 *             .type("Query")
 *             .dataSource(testDataSource.name())
 *             .requestTemplate("""
 * {
 *     "version": "2018-05-29",
 *     "method": "GET",
 *     "resourcePath": "/",
 *     "params":{
 *         "headers": $utils.http.copyheaders($ctx.request.headers)
 *     }
 * }
 *             """)
 *             .responseTemplate("""
 * #if($ctx.result.statusCode == 200)
 *     $ctx.result.body
 * #else
 *     $utils.appendError($ctx.result.body, $ctx.result.statusCode)
 * #end
 *             """)
 *             .cachingConfig(ResolverCachingConfigArgs.builder()
 *                 .cachingKeys(
 *                     "$context.identity.sub",
 *                     "$context.arguments.id")
 *                 .ttl(60)
 *                 .build())
 *             .build());
 *         var mutationPipelineTest = new Resolver("mutationPipelineTest", ResolverArgs.builder()
 *             .type("Mutation")
 *             .apiId(testGraphQLApi.id())
 *             .field("pipelineTest")
 *             .requestTemplate("{}")
 *             .responseTemplate("$util.toJson($ctx.result)")
 *             .kind("PIPELINE")
 *             .pipelineConfig(ResolverPipelineConfigArgs.builder()
 *                 .functions(
 *                     aws_appsync_function.test1().function_id(),
 *                     aws_appsync_function.test2().function_id(),
 *                     aws_appsync_function.test3().function_id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### JS
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.Resolver;
 * import com.pulumi.aws.appsync.ResolverArgs;
 * import com.pulumi.aws.appsync.inputs.ResolverRuntimeArgs;
 * import com.pulumi.aws.appsync.inputs.ResolverPipelineConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Resolver("example", ResolverArgs.builder()
 *             .type("Query")
 *             .apiId(aws_appsync_graphql_api.test().id())
 *             .field("pipelineTest")
 *             .kind("PIPELINE")
 *             .code(Files.readString(Paths.get("some-code-dir")))
 *             .runtime(ResolverRuntimeArgs.builder()
 *                 .name("APPSYNC_JS")
 *                 .runtimeVersion("1.0.0")
 *                 .build())
 *             .pipelineConfig(ResolverPipelineConfigArgs.builder()
 *                 .functions(aws_appsync_function.test().function_id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_appsync_resolver` using the `api_id`, a hyphen, `type`, a hypen and `field`. For example:
 * ```sh
 *  $ pulumi import aws:appsync/resolver:Resolver example abcdef123456-exampleType-exampleField
 * ```
 *
 */
public class Resolver internal constructor(
    override val javaResource: com.pulumi.aws.appsync.Resolver,
) : KotlinCustomResource(javaResource, ResolverMapper) {
    /**
     * API ID for the GraphQL API.
     */
    public val apiId: Output<String>
        get() = javaResource.apiId().applyValue({ args0 -> args0 })

    /**
     * ARN
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Caching Config. See Caching Config.
     */
    public val cachingConfig: Output<ResolverCachingConfig>?
        get() = javaResource.cachingConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> resolverCachingConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The function code that contains the request and response functions. When code is used, the runtime is required. The runtime value must be APPSYNC_JS.
     */
    public val code: Output<String>?
        get() = javaResource.code().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Data source name.
     */
    public val dataSource: Output<String>?
        get() = javaResource.dataSource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Field name from the schema defined in the GraphQL API.
     */
    public val `field`: Output<String>
        get() = javaResource.`field`().applyValue({ args0 -> args0 })

    /**
     * Resolver type. Valid values are `UNIT` and `PIPELINE`.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Maximum batching size for a resolver. Valid values are between `0` and `2000`.
     */
    public val maxBatchSize: Output<Int>?
        get() = javaResource.maxBatchSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The caching configuration for the resolver. See Pipeline Config.
     */
    public val pipelineConfig: Output<ResolverPipelineConfig>?
        get() = javaResource.pipelineConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> resolverPipelineConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Request mapping template for UNIT resolver or 'before mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
     */
    public val requestTemplate: Output<String>?
        get() = javaResource.requestTemplate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Response mapping template for UNIT resolver or 'after mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
     */
    public val responseTemplate: Output<String>?
        get() = javaResource.responseTemplate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified. See Runtime.
     */
    public val runtime: Output<ResolverRuntime>?
        get() = javaResource.runtime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resolverRuntimeToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Describes a Sync configuration for a resolver. See Sync Config.
     */
    public val syncConfig: Output<ResolverSyncConfig>?
        get() = javaResource.syncConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resolverSyncConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Type name from the schema defined in the GraphQL API.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ResolverMapper : ResourceMapper<Resolver> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appsync.Resolver::class == javaResource::class

    override fun map(javaResource: Resource): Resolver = Resolver(
        javaResource as
            com.pulumi.aws.appsync.Resolver,
    )
}

/**
 * @see [Resolver].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Resolver].
 */
public suspend fun resolver(name: String, block: suspend ResolverResourceBuilder.() -> Unit):
    Resolver {
    val builder = ResolverResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Resolver].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resolver(name: String): Resolver {
    val builder = ResolverResourceBuilder()
    builder.name(name)
    return builder.build()
}
