@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.aws.appsync.ResolverArgs.builder
import com.pulumi.aws.appsync.kotlin.inputs.ResolverCachingConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.ResolverCachingConfigArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.ResolverPipelineConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.ResolverPipelineConfigArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.ResolverRuntimeArgs
import com.pulumi.aws.appsync.kotlin.inputs.ResolverRuntimeArgsBuilder
import com.pulumi.aws.appsync.kotlin.inputs.ResolverSyncConfigArgs
import com.pulumi.aws.appsync.kotlin.inputs.ResolverSyncConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an AppSync Resolver.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.GraphQLApi;
 * import com.pulumi.aws.appsync.GraphQLApiArgs;
 * import com.pulumi.aws.appsync.DataSource;
 * import com.pulumi.aws.appsync.DataSourceArgs;
 * import com.pulumi.aws.appsync.inputs.DataSourceHttpConfigArgs;
 * import com.pulumi.aws.appsync.Resolver;
 * import com.pulumi.aws.appsync.ResolverArgs;
 * import com.pulumi.aws.appsync.inputs.ResolverCachingConfigArgs;
 * import com.pulumi.aws.appsync.inputs.ResolverPipelineConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testGraphQLApi = new GraphQLApi("testGraphQLApi", GraphQLApiArgs.builder()
 *             .authenticationType("API_KEY")
 *             .schema("""
 * type Mutation {
 * 	putPost(id: ID!, title: String!): Post
 * }
 * type Post {
 * 	id: ID!
 * 	title: String!
 * }
 * type Query {
 * 	singlePost(id: ID!): Post
 * }
 * schema {
 * 	query: Query
 * 	mutation: Mutation
 * }
 *             """)
 *             .build());
 *         var testDataSource = new DataSource("testDataSource", DataSourceArgs.builder()
 *             .apiId(testGraphQLApi.id())
 *             .name("my_example")
 *             .type("HTTP")
 *             .httpConfig(DataSourceHttpConfigArgs.builder()
 *                 .endpoint("http://example.com")
 *                 .build())
 *             .build());
 *         var testResolver = new Resolver("testResolver", ResolverArgs.builder()
 *             .apiId(testGraphQLApi.id())
 *             .field("singlePost")
 *             .type("Query")
 *             .dataSource(testDataSource.name())
 *             .requestTemplate("""
 * {
 *     "version": "2018-05-29",
 *     "method": "GET",
 *     "resourcePath": "/",
 *     "params":{
 *         "headers": $utils.http.copyheaders($ctx.request.headers)
 *     }
 * }
 *             """)
 *             .responseTemplate("""
 * #if($ctx.result.statusCode == 200)
 *     $ctx.result.body
 * #else
 *     $utils.appendError($ctx.result.body, $ctx.result.statusCode)
 * #end
 *             """)
 *             .cachingConfig(ResolverCachingConfigArgs.builder()
 *                 .cachingKeys(
 *                     "$context.identity.sub",
 *                     "$context.arguments.id")
 *                 .ttl(60)
 *                 .build())
 *             .build());
 *         var mutationPipelineTest = new Resolver("mutationPipelineTest", ResolverArgs.builder()
 *             .type("Mutation")
 *             .apiId(testGraphQLApi.id())
 *             .field("pipelineTest")
 *             .requestTemplate("{}")
 *             .responseTemplate("$util.toJson($ctx.result)")
 *             .kind("PIPELINE")
 *             .pipelineConfig(ResolverPipelineConfigArgs.builder()
 *                 .functions(
 *                     aws_appsync_function.test1().function_id(),
 *                     aws_appsync_function.test2().function_id(),
 *                     aws_appsync_function.test3().function_id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### JS
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.Resolver;
 * import com.pulumi.aws.appsync.ResolverArgs;
 * import com.pulumi.aws.appsync.inputs.ResolverRuntimeArgs;
 * import com.pulumi.aws.appsync.inputs.ResolverPipelineConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Resolver("example", ResolverArgs.builder()
 *             .type("Query")
 *             .apiId(aws_appsync_graphql_api.test().id())
 *             .field("pipelineTest")
 *             .kind("PIPELINE")
 *             .code(Files.readString(Paths.get("some-code-dir")))
 *             .runtime(ResolverRuntimeArgs.builder()
 *                 .name("APPSYNC_JS")
 *                 .runtimeVersion("1.0.0")
 *                 .build())
 *             .pipelineConfig(ResolverPipelineConfigArgs.builder()
 *                 .functions(aws_appsync_function.test().function_id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_appsync_resolver` using the `api_id`, a hyphen, `type`, a hypen and `field`. For example:
 * ```sh
 *  $ pulumi import aws:appsync/resolver:Resolver example abcdef123456-exampleType-exampleField
 * ```
 * @property apiId API ID for the GraphQL API.
 * @property cachingConfig The Caching Config. See Caching Config.
 * @property code The function code that contains the request and response functions. When code is used, the runtime is required. The runtime value must be APPSYNC_JS.
 * @property dataSource Data source name.
 * @property field Field name from the schema defined in the GraphQL API.
 * @property kind Resolver type. Valid values are `UNIT` and `PIPELINE`.
 * @property maxBatchSize Maximum batching size for a resolver. Valid values are between `0` and `2000`.
 * @property pipelineConfig The caching configuration for the resolver. See Pipeline Config.
 * @property requestTemplate Request mapping template for UNIT resolver or 'before mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
 * @property responseTemplate Response mapping template for UNIT resolver or 'after mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
 * @property runtime Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified. See Runtime.
 * @property syncConfig Describes a Sync configuration for a resolver. See Sync Config.
 * @property type Type name from the schema defined in the GraphQL API.
 */
public data class ResolverArgs(
    public val apiId: Output<String>? = null,
    public val cachingConfig: Output<ResolverCachingConfigArgs>? = null,
    public val code: Output<String>? = null,
    public val dataSource: Output<String>? = null,
    public val `field`: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val maxBatchSize: Output<Int>? = null,
    public val pipelineConfig: Output<ResolverPipelineConfigArgs>? = null,
    public val requestTemplate: Output<String>? = null,
    public val responseTemplate: Output<String>? = null,
    public val runtime: Output<ResolverRuntimeArgs>? = null,
    public val syncConfig: Output<ResolverSyncConfigArgs>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appsync.ResolverArgs> {
    override fun toJava(): com.pulumi.aws.appsync.ResolverArgs =
        com.pulumi.aws.appsync.ResolverArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .cachingConfig(cachingConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .code(code?.applyValue({ args0 -> args0 }))
            .dataSource(dataSource?.applyValue({ args0 -> args0 }))
            .`field`(`field`?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .maxBatchSize(maxBatchSize?.applyValue({ args0 -> args0 }))
            .pipelineConfig(pipelineConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .requestTemplate(requestTemplate?.applyValue({ args0 -> args0 }))
            .responseTemplate(responseTemplate?.applyValue({ args0 -> args0 }))
            .runtime(runtime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .syncConfig(syncConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResolverArgs].
 */
@PulumiTagMarker
public class ResolverArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var cachingConfig: Output<ResolverCachingConfigArgs>? = null

    private var code: Output<String>? = null

    private var dataSource: Output<String>? = null

    private var `field`: Output<String>? = null

    private var kind: Output<String>? = null

    private var maxBatchSize: Output<Int>? = null

    private var pipelineConfig: Output<ResolverPipelineConfigArgs>? = null

    private var requestTemplate: Output<String>? = null

    private var responseTemplate: Output<String>? = null

    private var runtime: Output<ResolverRuntimeArgs>? = null

    private var syncConfig: Output<ResolverSyncConfigArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value API ID for the GraphQL API.
     */
    @JvmName("tcossobqkopfgnqk")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value The Caching Config. See Caching Config.
     */
    @JvmName("lnlfmrqcdqanjtxd")
    public suspend fun cachingConfig(`value`: Output<ResolverCachingConfigArgs>) {
        this.cachingConfig = value
    }

    /**
     * @param value The function code that contains the request and response functions. When code is used, the runtime is required. The runtime value must be APPSYNC_JS.
     */
    @JvmName("whrxpitgfvlgeglu")
    public suspend fun code(`value`: Output<String>) {
        this.code = value
    }

    /**
     * @param value Data source name.
     */
    @JvmName("tqxmvclbrpcftgoy")
    public suspend fun dataSource(`value`: Output<String>) {
        this.dataSource = value
    }

    /**
     * @param value Field name from the schema defined in the GraphQL API.
     */
    @JvmName("oqmnxsdcroabfksa")
    public suspend fun `field`(`value`: Output<String>) {
        this.`field` = value
    }

    /**
     * @param value Resolver type. Valid values are `UNIT` and `PIPELINE`.
     */
    @JvmName("avyafwnjrmkegohk")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Maximum batching size for a resolver. Valid values are between `0` and `2000`.
     */
    @JvmName("suexnknqfiexjumv")
    public suspend fun maxBatchSize(`value`: Output<Int>) {
        this.maxBatchSize = value
    }

    /**
     * @param value The caching configuration for the resolver. See Pipeline Config.
     */
    @JvmName("tfgptohettqqqkhb")
    public suspend fun pipelineConfig(`value`: Output<ResolverPipelineConfigArgs>) {
        this.pipelineConfig = value
    }

    /**
     * @param value Request mapping template for UNIT resolver or 'before mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
     */
    @JvmName("elfsjbffkafyoueq")
    public suspend fun requestTemplate(`value`: Output<String>) {
        this.requestTemplate = value
    }

    /**
     * @param value Response mapping template for UNIT resolver or 'after mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
     */
    @JvmName("ovxvuadixmpwbhni")
    public suspend fun responseTemplate(`value`: Output<String>) {
        this.responseTemplate = value
    }

    /**
     * @param value Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified. See Runtime.
     */
    @JvmName("kobjpuyrwijlsfoc")
    public suspend fun runtime(`value`: Output<ResolverRuntimeArgs>) {
        this.runtime = value
    }

    /**
     * @param value Describes a Sync configuration for a resolver. See Sync Config.
     */
    @JvmName("fmogyqnxvlxenuub")
    public suspend fun syncConfig(`value`: Output<ResolverSyncConfigArgs>) {
        this.syncConfig = value
    }

    /**
     * @param value Type name from the schema defined in the GraphQL API.
     */
    @JvmName("ofbafocpsygewkug")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value API ID for the GraphQL API.
     */
    @JvmName("rvnpmhmspgrtvinv")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value The Caching Config. See Caching Config.
     */
    @JvmName("dgyenccfdfahedtg")
    public suspend fun cachingConfig(`value`: ResolverCachingConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cachingConfig = mapped
    }

    /**
     * @param argument The Caching Config. See Caching Config.
     */
    @JvmName("ljrekjtkwynjpolq")
    public suspend fun cachingConfig(argument: suspend ResolverCachingConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ResolverCachingConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cachingConfig = mapped
    }

    /**
     * @param value The function code that contains the request and response functions. When code is used, the runtime is required. The runtime value must be APPSYNC_JS.
     */
    @JvmName("ukjjejuvpjbvytsi")
    public suspend fun code(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value Data source name.
     */
    @JvmName("ebbkaelcciffnipu")
    public suspend fun dataSource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSource = mapped
    }

    /**
     * @param value Field name from the schema defined in the GraphQL API.
     */
    @JvmName("gjlqswiguptjfwna")
    public suspend fun `field`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`field` = mapped
    }

    /**
     * @param value Resolver type. Valid values are `UNIT` and `PIPELINE`.
     */
    @JvmName("oxafplrvktxhawge")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Maximum batching size for a resolver. Valid values are between `0` and `2000`.
     */
    @JvmName("fxmnadwcgtyndjtg")
    public suspend fun maxBatchSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxBatchSize = mapped
    }

    /**
     * @param value The caching configuration for the resolver. See Pipeline Config.
     */
    @JvmName("flnmgcnuslrykckx")
    public suspend fun pipelineConfig(`value`: ResolverPipelineConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineConfig = mapped
    }

    /**
     * @param argument The caching configuration for the resolver. See Pipeline Config.
     */
    @JvmName("ymjvxwujqqfrpjeh")
    public suspend
    fun pipelineConfig(argument: suspend ResolverPipelineConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ResolverPipelineConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.pipelineConfig = mapped
    }

    /**
     * @param value Request mapping template for UNIT resolver or 'before mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
     */
    @JvmName("gmsqjismubfmgswu")
    public suspend fun requestTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestTemplate = mapped
    }

    /**
     * @param value Response mapping template for UNIT resolver or 'after mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
     */
    @JvmName("pffrgeydipiwwjrf")
    public suspend fun responseTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseTemplate = mapped
    }

    /**
     * @param value Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified. See Runtime.
     */
    @JvmName("quhmjxffnptwdewx")
    public suspend fun runtime(`value`: ResolverRuntimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtime = mapped
    }

    /**
     * @param argument Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified. See Runtime.
     */
    @JvmName("stqvdmvsvnktahxk")
    public suspend fun runtime(argument: suspend ResolverRuntimeArgsBuilder.() -> Unit) {
        val toBeMapped = ResolverRuntimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.runtime = mapped
    }

    /**
     * @param value Describes a Sync configuration for a resolver. See Sync Config.
     */
    @JvmName("jldqisohnpdljliu")
    public suspend fun syncConfig(`value`: ResolverSyncConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncConfig = mapped
    }

    /**
     * @param argument Describes a Sync configuration for a resolver. See Sync Config.
     */
    @JvmName("kariwuhcfnaqppia")
    public suspend fun syncConfig(argument: suspend ResolverSyncConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ResolverSyncConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.syncConfig = mapped
    }

    /**
     * @param value Type name from the schema defined in the GraphQL API.
     */
    @JvmName("uixhaypacqnqrosn")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ResolverArgs = ResolverArgs(
        apiId = apiId,
        cachingConfig = cachingConfig,
        code = code,
        dataSource = dataSource,
        `field` = `field`,
        kind = kind,
        maxBatchSize = maxBatchSize,
        pipelineConfig = pipelineConfig,
        requestTemplate = requestTemplate,
        responseTemplate = responseTemplate,
        runtime = runtime,
        syncConfig = syncConfig,
        type = type,
    )
}
