@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Type].
 */
@PulumiTagMarker
public class TypeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TypeArgs = TypeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TypeArgsBuilder.() -> Unit) {
        val builder = TypeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Type {
        val builtJavaResource = com.pulumi.aws.appsync.Type(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Type(builtJavaResource)
    }
}

/**
 * Provides an AppSync Type.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.GraphQLApi;
 * import com.pulumi.aws.appsync.GraphQLApiArgs;
 * import com.pulumi.aws.appsync.Type;
 * import com.pulumi.aws.appsync.TypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGraphQLApi = new GraphQLApi("exampleGraphQLApi", GraphQLApiArgs.builder()
 *             .authenticationType("API_KEY")
 *             .build());
 *         var exampleType = new Type("exampleType", TypeArgs.builder()
 *             .apiId(exampleGraphQLApi.id())
 *             .format("SDL")
 *             .definition("""
 * type Mutation
 * {
 * putPost(id: ID!,title: String! ): Post
 * }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Appsync Types using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:appsync/type:Type example api-id:format:name
 * ```
 *
 */
public class Type internal constructor(
    override val javaResource: com.pulumi.aws.appsync.Type,
) : KotlinCustomResource(javaResource, TypeMapper) {
    /**
     * GraphQL API ID.
     */
    public val apiId: Output<String>
        get() = javaResource.apiId().applyValue({ args0 -> args0 })

    /**
     * The ARN of the type.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The type definition.
     */
    public val definition: Output<String>
        get() = javaResource.definition().applyValue({ args0 -> args0 })

    /**
     * The type description.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The type format: `SDL` or `JSON`.
     */
    public val format: Output<String>
        get() = javaResource.format().applyValue({ args0 -> args0 })

    /**
     * The type name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object TypeMapper : ResourceMapper<Type> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appsync.Type::class == javaResource::class

    override fun map(javaResource: Resource): Type = Type(javaResource as com.pulumi.aws.appsync.Type)
}

/**
 * @see [Type].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Type].
 */
public suspend fun type(name: String, block: suspend TypeResourceBuilder.() -> Unit): Type {
    val builder = TypeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Type].
 * @param name The _unique_ name of the resulting resource.
 */
public fun type(name: String): Type {
    val builder = TypeResourceBuilder()
    builder.name(name)
    return builder.build()
}
