@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin

import com.pulumi.aws.appsync.TypeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an AppSync Type.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appsync.GraphQLApi;
 * import com.pulumi.aws.appsync.GraphQLApiArgs;
 * import com.pulumi.aws.appsync.Type;
 * import com.pulumi.aws.appsync.TypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGraphQLApi = new GraphQLApi("exampleGraphQLApi", GraphQLApiArgs.builder()
 *             .authenticationType("API_KEY")
 *             .build());
 *         var exampleType = new Type("exampleType", TypeArgs.builder()
 *             .apiId(exampleGraphQLApi.id())
 *             .format("SDL")
 *             .definition("""
 * type Mutation
 * {
 * putPost(id: ID!,title: String! ): Post
 * }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Appsync Types using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:appsync/type:Type example api-id:format:name
 * ```
 * @property apiId GraphQL API ID.
 * @property definition The type definition.
 * @property format The type format: `SDL` or `JSON`.
 */
public data class TypeArgs(
    public val apiId: Output<String>? = null,
    public val definition: Output<String>? = null,
    public val format: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appsync.TypeArgs> {
    override fun toJava(): com.pulumi.aws.appsync.TypeArgs = com.pulumi.aws.appsync.TypeArgs.builder()
        .apiId(apiId?.applyValue({ args0 -> args0 }))
        .definition(definition?.applyValue({ args0 -> args0 }))
        .format(format?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TypeArgs].
 */
@PulumiTagMarker
public class TypeArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var definition: Output<String>? = null

    private var format: Output<String>? = null

    /**
     * @param value GraphQL API ID.
     */
    @JvmName("akhiotrvvdrmcyut")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value The type definition.
     */
    @JvmName("kxwgmvytvxakvusk")
    public suspend fun definition(`value`: Output<String>) {
        this.definition = value
    }

    /**
     * @param value The type format: `SDL` or `JSON`.
     */
    @JvmName("kfjjflfswfivwkde")
    public suspend fun format(`value`: Output<String>) {
        this.format = value
    }

    /**
     * @param value GraphQL API ID.
     */
    @JvmName("vchmycsyrmmdmmgi")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value The type definition.
     */
    @JvmName("enwsamcuxhqsndju")
    public suspend fun definition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.definition = mapped
    }

    /**
     * @param value The type format: `SDL` or `JSON`.
     */
    @JvmName("pdtqrymbiflddrdr")
    public suspend fun format(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    internal fun build(): TypeArgs = TypeArgs(
        apiId = apiId,
        definition = definition,
        format = format,
    )
}
