@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.inputs

import com.pulumi.aws.appsync.inputs.DataSourceDynamodbConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property deltaSyncConfig The DeltaSyncConfig for a versioned data source. See Delta Sync Config
 * @property region AWS region of the DynamoDB table. Defaults to current region.
 * @property tableName Name of the DynamoDB table.
 * @property useCallerCredentials Set to `true` to use Amazon Cognito credentials with this data source.
 * @property versioned Detects Conflict Detection and Resolution with this data source.
 */
public data class DataSourceDynamodbConfigArgs(
    public val deltaSyncConfig: Output<DataSourceDynamodbConfigDeltaSyncConfigArgs>? = null,
    public val region: Output<String>? = null,
    public val tableName: Output<String>,
    public val useCallerCredentials: Output<Boolean>? = null,
    public val versioned: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.appsync.inputs.DataSourceDynamodbConfigArgs> {
    override fun toJava(): com.pulumi.aws.appsync.inputs.DataSourceDynamodbConfigArgs =
        com.pulumi.aws.appsync.inputs.DataSourceDynamodbConfigArgs.builder()
            .deltaSyncConfig(deltaSyncConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .region(region?.applyValue({ args0 -> args0 }))
            .tableName(tableName.applyValue({ args0 -> args0 }))
            .useCallerCredentials(useCallerCredentials?.applyValue({ args0 -> args0 }))
            .versioned(versioned?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceDynamodbConfigArgs].
 */
@PulumiTagMarker
public class DataSourceDynamodbConfigArgsBuilder internal constructor() {
    private var deltaSyncConfig: Output<DataSourceDynamodbConfigDeltaSyncConfigArgs>? = null

    private var region: Output<String>? = null

    private var tableName: Output<String>? = null

    private var useCallerCredentials: Output<Boolean>? = null

    private var versioned: Output<Boolean>? = null

    /**
     * @param value The DeltaSyncConfig for a versioned data source. See Delta Sync Config
     */
    @JvmName("nbylupttebpivuxk")
    public suspend fun deltaSyncConfig(`value`: Output<DataSourceDynamodbConfigDeltaSyncConfigArgs>) {
        this.deltaSyncConfig = value
    }

    /**
     * @param value AWS region of the DynamoDB table. Defaults to current region.
     */
    @JvmName("ildtlfnreenlnlse")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value Name of the DynamoDB table.
     */
    @JvmName("qmqwbfuwilaymnro")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value Set to `true` to use Amazon Cognito credentials with this data source.
     */
    @JvmName("cddbxtclojejhsjv")
    public suspend fun useCallerCredentials(`value`: Output<Boolean>) {
        this.useCallerCredentials = value
    }

    /**
     * @param value Detects Conflict Detection and Resolution with this data source.
     */
    @JvmName("vgiygiaxnkxaywce")
    public suspend fun versioned(`value`: Output<Boolean>) {
        this.versioned = value
    }

    /**
     * @param value The DeltaSyncConfig for a versioned data source. See Delta Sync Config
     */
    @JvmName("xepppnkiwwkyrfes")
    public suspend fun deltaSyncConfig(`value`: DataSourceDynamodbConfigDeltaSyncConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deltaSyncConfig = mapped
    }

    /**
     * @param argument The DeltaSyncConfig for a versioned data source. See Delta Sync Config
     */
    @JvmName("xxirslophbifqljj")
    public suspend
    fun deltaSyncConfig(argument: suspend DataSourceDynamodbConfigDeltaSyncConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceDynamodbConfigDeltaSyncConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.deltaSyncConfig = mapped
    }

    /**
     * @param value AWS region of the DynamoDB table. Defaults to current region.
     */
    @JvmName("sbhwujwnvhckapfk")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value Name of the DynamoDB table.
     */
    @JvmName("ndjegrljkkrqbndf")
    public suspend fun tableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    /**
     * @param value Set to `true` to use Amazon Cognito credentials with this data source.
     */
    @JvmName("gmbettmmwxlmynft")
    public suspend fun useCallerCredentials(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useCallerCredentials = mapped
    }

    /**
     * @param value Detects Conflict Detection and Resolution with this data source.
     */
    @JvmName("qcksdmvddtgpsvtw")
    public suspend fun versioned(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versioned = mapped
    }

    internal fun build(): DataSourceDynamodbConfigArgs = DataSourceDynamodbConfigArgs(
        deltaSyncConfig = deltaSyncConfig,
        region = region,
        tableName = tableName ?: throw PulumiNullFieldException("tableName"),
        useCallerCredentials = useCallerCredentials,
        versioned = versioned,
    )
}
