@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.inputs

import com.pulumi.aws.appsync.inputs.DataSourceDynamodbConfigDeltaSyncConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property baseTableTtl The number of minutes that an Item is stored in the data source.
 * @property deltaSyncTableName The table name.
 * @property deltaSyncTableTtl The number of minutes that a Delta Sync log entry is stored in the Delta Sync table.
 */
public data class DataSourceDynamodbConfigDeltaSyncConfigArgs(
    public val baseTableTtl: Output<Int>? = null,
    public val deltaSyncTableName: Output<String>,
    public val deltaSyncTableTtl: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.appsync.inputs.DataSourceDynamodbConfigDeltaSyncConfigArgs> {
    override fun toJava(): com.pulumi.aws.appsync.inputs.DataSourceDynamodbConfigDeltaSyncConfigArgs =
        com.pulumi.aws.appsync.inputs.DataSourceDynamodbConfigDeltaSyncConfigArgs.builder()
            .baseTableTtl(baseTableTtl?.applyValue({ args0 -> args0 }))
            .deltaSyncTableName(deltaSyncTableName.applyValue({ args0 -> args0 }))
            .deltaSyncTableTtl(deltaSyncTableTtl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceDynamodbConfigDeltaSyncConfigArgs].
 */
@PulumiTagMarker
public class DataSourceDynamodbConfigDeltaSyncConfigArgsBuilder internal constructor() {
    private var baseTableTtl: Output<Int>? = null

    private var deltaSyncTableName: Output<String>? = null

    private var deltaSyncTableTtl: Output<Int>? = null

    /**
     * @param value The number of minutes that an Item is stored in the data source.
     */
    @JvmName("fnmwvcndyelhedbj")
    public suspend fun baseTableTtl(`value`: Output<Int>) {
        this.baseTableTtl = value
    }

    /**
     * @param value The table name.
     */
    @JvmName("hissefaeeojqhjfj")
    public suspend fun deltaSyncTableName(`value`: Output<String>) {
        this.deltaSyncTableName = value
    }

    /**
     * @param value The number of minutes that a Delta Sync log entry is stored in the Delta Sync table.
     */
    @JvmName("aqrglkwhpwbbylei")
    public suspend fun deltaSyncTableTtl(`value`: Output<Int>) {
        this.deltaSyncTableTtl = value
    }

    /**
     * @param value The number of minutes that an Item is stored in the data source.
     */
    @JvmName("cumyyieikapgoaqx")
    public suspend fun baseTableTtl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baseTableTtl = mapped
    }

    /**
     * @param value The table name.
     */
    @JvmName("inivfxsieqxydclr")
    public suspend fun deltaSyncTableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deltaSyncTableName = mapped
    }

    /**
     * @param value The number of minutes that a Delta Sync log entry is stored in the Delta Sync table.
     */
    @JvmName("atiaxrtsdqlmqjnt")
    public suspend fun deltaSyncTableTtl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deltaSyncTableTtl = mapped
    }

    internal fun build(): DataSourceDynamodbConfigDeltaSyncConfigArgs =
        DataSourceDynamodbConfigDeltaSyncConfigArgs(
            baseTableTtl = baseTableTtl,
            deltaSyncTableName = deltaSyncTableName ?: throw PulumiNullFieldException("deltaSyncTableName"),
            deltaSyncTableTtl = deltaSyncTableTtl,
        )
}
