@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.inputs

import com.pulumi.aws.appsync.inputs.DataSourceElasticsearchConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endpoint HTTP endpoint of the Elasticsearch domain.
 * @property region AWS region of Elasticsearch domain. Defaults to current region.
 */
public data class DataSourceElasticsearchConfigArgs(
    public val endpoint: Output<String>,
    public val region: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appsync.inputs.DataSourceElasticsearchConfigArgs> {
    override fun toJava(): com.pulumi.aws.appsync.inputs.DataSourceElasticsearchConfigArgs =
        com.pulumi.aws.appsync.inputs.DataSourceElasticsearchConfigArgs.builder()
            .endpoint(endpoint.applyValue({ args0 -> args0 }))
            .region(region?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceElasticsearchConfigArgs].
 */
@PulumiTagMarker
public class DataSourceElasticsearchConfigArgsBuilder internal constructor() {
    private var endpoint: Output<String>? = null

    private var region: Output<String>? = null

    /**
     * @param value HTTP endpoint of the Elasticsearch domain.
     */
    @JvmName("tykrmgotocmalndp")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value AWS region of Elasticsearch domain. Defaults to current region.
     */
    @JvmName("akxkutidygijhref")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value HTTP endpoint of the Elasticsearch domain.
     */
    @JvmName("pjifhsowavvchnfc")
    public suspend fun endpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value AWS region of Elasticsearch domain. Defaults to current region.
     */
    @JvmName("csikyathvwafjuqx")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    internal fun build(): DataSourceElasticsearchConfigArgs = DataSourceElasticsearchConfigArgs(
        endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
        region = region,
    )
}
