@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.inputs

import com.pulumi.aws.appsync.inputs.DataSourceHttpConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property authorizationConfig Authorization configuration in case the HTTP endpoint requires authorization. See Authorization Config.
 * @property endpoint HTTP URL.
 */
public data class DataSourceHttpConfigArgs(
    public val authorizationConfig: Output<DataSourceHttpConfigAuthorizationConfigArgs>? = null,
    public val endpoint: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appsync.inputs.DataSourceHttpConfigArgs> {
    override fun toJava(): com.pulumi.aws.appsync.inputs.DataSourceHttpConfigArgs =
        com.pulumi.aws.appsync.inputs.DataSourceHttpConfigArgs.builder()
            .authorizationConfig(
                authorizationConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .endpoint(endpoint.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceHttpConfigArgs].
 */
@PulumiTagMarker
public class DataSourceHttpConfigArgsBuilder internal constructor() {
    private var authorizationConfig: Output<DataSourceHttpConfigAuthorizationConfigArgs>? = null

    private var endpoint: Output<String>? = null

    /**
     * @param value Authorization configuration in case the HTTP endpoint requires authorization. See Authorization Config.
     */
    @JvmName("fcpthldsykftsaqb")
    public suspend
    fun authorizationConfig(`value`: Output<DataSourceHttpConfigAuthorizationConfigArgs>) {
        this.authorizationConfig = value
    }

    /**
     * @param value HTTP URL.
     */
    @JvmName("fslrkcuanbnlstmj")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value Authorization configuration in case the HTTP endpoint requires authorization. See Authorization Config.
     */
    @JvmName("ocjnsspaiwwxonvs")
    public suspend fun authorizationConfig(`value`: DataSourceHttpConfigAuthorizationConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationConfig = mapped
    }

    /**
     * @param argument Authorization configuration in case the HTTP endpoint requires authorization. See Authorization Config.
     */
    @JvmName("qfwbmicyjuoooinv")
    public suspend
    fun authorizationConfig(argument: suspend DataSourceHttpConfigAuthorizationConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceHttpConfigAuthorizationConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.authorizationConfig = mapped
    }

    /**
     * @param value HTTP URL.
     */
    @JvmName("lokpgkjnfmmpxksr")
    public suspend fun endpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    internal fun build(): DataSourceHttpConfigArgs = DataSourceHttpConfigArgs(
        authorizationConfig = authorizationConfig,
        endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
    )
}
