@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.inputs

import com.pulumi.aws.appsync.inputs.DataSourceHttpConfigAuthorizationConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property authorizationType Authorization type that the HTTP endpoint requires. Default values is `AWS_IAM`.
 * @property awsIamConfig Identity and Access Management (IAM) settings. See AWS IAM Config.
 */
public data class DataSourceHttpConfigAuthorizationConfigArgs(
    public val authorizationType: Output<String>? = null,
    public val awsIamConfig: Output<DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appsync.inputs.DataSourceHttpConfigAuthorizationConfigArgs> {
    override fun toJava(): com.pulumi.aws.appsync.inputs.DataSourceHttpConfigAuthorizationConfigArgs =
        com.pulumi.aws.appsync.inputs.DataSourceHttpConfigAuthorizationConfigArgs.builder()
            .authorizationType(authorizationType?.applyValue({ args0 -> args0 }))
            .awsIamConfig(awsIamConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DataSourceHttpConfigAuthorizationConfigArgs].
 */
@PulumiTagMarker
public class DataSourceHttpConfigAuthorizationConfigArgsBuilder internal constructor() {
    private var authorizationType: Output<String>? = null

    private var awsIamConfig: Output<DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgs>? = null

    /**
     * @param value Authorization type that the HTTP endpoint requires. Default values is `AWS_IAM`.
     */
    @JvmName("gsxsfystgpjyxdvk")
    public suspend fun authorizationType(`value`: Output<String>) {
        this.authorizationType = value
    }

    /**
     * @param value Identity and Access Management (IAM) settings. See AWS IAM Config.
     */
    @JvmName("fipcyxglxkjaokii")
    public suspend
    fun awsIamConfig(`value`: Output<DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgs>) {
        this.awsIamConfig = value
    }

    /**
     * @param value Authorization type that the HTTP endpoint requires. Default values is `AWS_IAM`.
     */
    @JvmName("yohcywdatdayesxj")
    public suspend fun authorizationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationType = mapped
    }

    /**
     * @param value Identity and Access Management (IAM) settings. See AWS IAM Config.
     */
    @JvmName("ngnlrndnjefsioqh")
    public suspend
    fun awsIamConfig(`value`: DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsIamConfig = mapped
    }

    /**
     * @param argument Identity and Access Management (IAM) settings. See AWS IAM Config.
     */
    @JvmName("eijyablefwumomrb")
    public suspend
    fun awsIamConfig(argument: suspend DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.awsIamConfig = mapped
    }

    internal fun build(): DataSourceHttpConfigAuthorizationConfigArgs =
        DataSourceHttpConfigAuthorizationConfigArgs(
            authorizationType = authorizationType,
            awsIamConfig = awsIamConfig,
        )
}
