@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.inputs

import com.pulumi.aws.appsync.inputs.DataSourceLambdaConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property functionArn ARN for the Lambda function.
 */
public data class DataSourceLambdaConfigArgs(
    public val functionArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appsync.inputs.DataSourceLambdaConfigArgs> {
    override fun toJava(): com.pulumi.aws.appsync.inputs.DataSourceLambdaConfigArgs =
        com.pulumi.aws.appsync.inputs.DataSourceLambdaConfigArgs.builder()
            .functionArn(functionArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceLambdaConfigArgs].
 */
@PulumiTagMarker
public class DataSourceLambdaConfigArgsBuilder internal constructor() {
    private var functionArn: Output<String>? = null

    /**
     * @param value ARN for the Lambda function.
     */
    @JvmName("rjimumdhertfhgme")
    public suspend fun functionArn(`value`: Output<String>) {
        this.functionArn = value
    }

    /**
     * @param value ARN for the Lambda function.
     */
    @JvmName("ekwfkqcpfamopana")
    public suspend fun functionArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.functionArn = mapped
    }

    internal fun build(): DataSourceLambdaConfigArgs = DataSourceLambdaConfigArgs(
        functionArn = functionArn ?: throw PulumiNullFieldException("functionArn"),
    )
}
