@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.inputs

import com.pulumi.aws.appsync.inputs.DataSourceRelationalDatabaseConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property httpEndpointConfig Amazon RDS HTTP endpoint configuration. See HTTP Endpoint Config.
 * @property sourceType Source type for the relational database. Valid values: `RDS_HTTP_ENDPOINT`.
 */
public data class DataSourceRelationalDatabaseConfigArgs(
    public val httpEndpointConfig: Output<DataSourceRelationalDatabaseConfigHttpEndpointConfigArgs>? =
        null,
    public val sourceType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appsync.inputs.DataSourceRelationalDatabaseConfigArgs> {
    override fun toJava(): com.pulumi.aws.appsync.inputs.DataSourceRelationalDatabaseConfigArgs =
        com.pulumi.aws.appsync.inputs.DataSourceRelationalDatabaseConfigArgs.builder()
            .httpEndpointConfig(
                httpEndpointConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sourceType(sourceType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceRelationalDatabaseConfigArgs].
 */
@PulumiTagMarker
public class DataSourceRelationalDatabaseConfigArgsBuilder internal constructor() {
    private var httpEndpointConfig: Output<DataSourceRelationalDatabaseConfigHttpEndpointConfigArgs>? =
        null

    private var sourceType: Output<String>? = null

    /**
     * @param value Amazon RDS HTTP endpoint configuration. See HTTP Endpoint Config.
     */
    @JvmName("jxeawdtvldrrncox")
    public suspend
    fun httpEndpointConfig(`value`: Output<DataSourceRelationalDatabaseConfigHttpEndpointConfigArgs>) {
        this.httpEndpointConfig = value
    }

    /**
     * @param value Source type for the relational database. Valid values: `RDS_HTTP_ENDPOINT`.
     */
    @JvmName("byrtupjafsjkgxhy")
    public suspend fun sourceType(`value`: Output<String>) {
        this.sourceType = value
    }

    /**
     * @param value Amazon RDS HTTP endpoint configuration. See HTTP Endpoint Config.
     */
    @JvmName("tfwsdmpoclicwxqp")
    public suspend
    fun httpEndpointConfig(`value`: DataSourceRelationalDatabaseConfigHttpEndpointConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpEndpointConfig = mapped
    }

    /**
     * @param argument Amazon RDS HTTP endpoint configuration. See HTTP Endpoint Config.
     */
    @JvmName("ujwcpsihurbqdibu")
    public suspend
    fun httpEndpointConfig(argument: suspend DataSourceRelationalDatabaseConfigHttpEndpointConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceRelationalDatabaseConfigHttpEndpointConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.httpEndpointConfig = mapped
    }

    /**
     * @param value Source type for the relational database. Valid values: `RDS_HTTP_ENDPOINT`.
     */
    @JvmName("ilgxxgbaqwyhkhde")
    public suspend fun sourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    internal fun build(): DataSourceRelationalDatabaseConfigArgs =
        DataSourceRelationalDatabaseConfigArgs(
            httpEndpointConfig = httpEndpointConfig,
            sourceType = sourceType,
        )
}
