@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.inputs

import com.pulumi.aws.appsync.inputs.DataSourceRelationalDatabaseConfigHttpEndpointConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property awsSecretStoreArn AWS secret store ARN for database credentials.
 * @property databaseName Logical database name.
 * @property dbClusterIdentifier Amazon RDS cluster identifier.
 * @property region AWS Region for RDS HTTP endpoint. Defaults to current region.
 * @property schema Logical schema name.
 */
public data class DataSourceRelationalDatabaseConfigHttpEndpointConfigArgs(
    public val awsSecretStoreArn: Output<String>,
    public val databaseName: Output<String>? = null,
    public val dbClusterIdentifier: Output<String>,
    public val region: Output<String>? = null,
    public val schema: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appsync.inputs.DataSourceRelationalDatabaseConfigHttpEndpointConfigArgs> {
    override fun toJava():
        com.pulumi.aws.appsync.inputs.DataSourceRelationalDatabaseConfigHttpEndpointConfigArgs =
        com.pulumi.aws.appsync.inputs.DataSourceRelationalDatabaseConfigHttpEndpointConfigArgs.builder()
            .awsSecretStoreArn(awsSecretStoreArn.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .dbClusterIdentifier(dbClusterIdentifier.applyValue({ args0 -> args0 }))
            .region(region?.applyValue({ args0 -> args0 }))
            .schema(schema?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceRelationalDatabaseConfigHttpEndpointConfigArgs].
 */
@PulumiTagMarker
public class DataSourceRelationalDatabaseConfigHttpEndpointConfigArgsBuilder internal constructor() {
    private var awsSecretStoreArn: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var dbClusterIdentifier: Output<String>? = null

    private var region: Output<String>? = null

    private var schema: Output<String>? = null

    /**
     * @param value AWS secret store ARN for database credentials.
     */
    @JvmName("klrtyamtuynbytdd")
    public suspend fun awsSecretStoreArn(`value`: Output<String>) {
        this.awsSecretStoreArn = value
    }

    /**
     * @param value Logical database name.
     */
    @JvmName("yunyoatrctsjiypj")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Amazon RDS cluster identifier.
     */
    @JvmName("xtgqhljkbvynhsiv")
    public suspend fun dbClusterIdentifier(`value`: Output<String>) {
        this.dbClusterIdentifier = value
    }

    /**
     * @param value AWS Region for RDS HTTP endpoint. Defaults to current region.
     */
    @JvmName("pggwquvvswtbomsb")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value Logical schema name.
     */
    @JvmName("aetqonyktdllcccl")
    public suspend fun schema(`value`: Output<String>) {
        this.schema = value
    }

    /**
     * @param value AWS secret store ARN for database credentials.
     */
    @JvmName("xjomytcfycmslhxa")
    public suspend fun awsSecretStoreArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.awsSecretStoreArn = mapped
    }

    /**
     * @param value Logical database name.
     */
    @JvmName("icvgxruiplinldjb")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Amazon RDS cluster identifier.
     */
    @JvmName("qhannauebcexrgud")
    public suspend fun dbClusterIdentifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dbClusterIdentifier = mapped
    }

    /**
     * @param value AWS Region for RDS HTTP endpoint. Defaults to current region.
     */
    @JvmName("mtbriudhtxdjkprb")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value Logical schema name.
     */
    @JvmName("otfjyxwveujscslg")
    public suspend fun schema(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    internal fun build(): DataSourceRelationalDatabaseConfigHttpEndpointConfigArgs =
        DataSourceRelationalDatabaseConfigHttpEndpointConfigArgs(
            awsSecretStoreArn = awsSecretStoreArn ?: throw PulumiNullFieldException("awsSecretStoreArn"),
            databaseName = databaseName,
            dbClusterIdentifier = dbClusterIdentifier ?: throw PulumiNullFieldException("dbClusterIdentifier"),
            region = region,
            schema = schema,
        )
}
