@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.inputs

import com.pulumi.aws.appsync.inputs.FunctionSyncConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property conflictDetection Conflict Detection strategy to use. Valid values are `NONE` and `VERSION`.
 * @property conflictHandler Conflict Resolution strategy to perform in the event of a conflict. Valid values are `NONE`, `OPTIMISTIC_CONCURRENCY`, `AUTOMERGE`, and `LAMBDA`.
 * @property lambdaConflictHandlerConfig Lambda Conflict Handler Config when configuring `LAMBDA` as the Conflict Handler. See Lambda Conflict Handler Config.
 */
public data class FunctionSyncConfigArgs(
    public val conflictDetection: Output<String>? = null,
    public val conflictHandler: Output<String>? = null,
    public val lambdaConflictHandlerConfig: Output<FunctionSyncConfigLambdaConflictHandlerConfigArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.appsync.inputs.FunctionSyncConfigArgs> {
    override fun toJava(): com.pulumi.aws.appsync.inputs.FunctionSyncConfigArgs =
        com.pulumi.aws.appsync.inputs.FunctionSyncConfigArgs.builder()
            .conflictDetection(conflictDetection?.applyValue({ args0 -> args0 }))
            .conflictHandler(conflictHandler?.applyValue({ args0 -> args0 }))
            .lambdaConflictHandlerConfig(
                lambdaConflictHandlerConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [FunctionSyncConfigArgs].
 */
@PulumiTagMarker
public class FunctionSyncConfigArgsBuilder internal constructor() {
    private var conflictDetection: Output<String>? = null

    private var conflictHandler: Output<String>? = null

    private var lambdaConflictHandlerConfig:
        Output<FunctionSyncConfigLambdaConflictHandlerConfigArgs>? = null

    /**
     * @param value Conflict Detection strategy to use. Valid values are `NONE` and `VERSION`.
     */
    @JvmName("sbbpnlccboljadlc")
    public suspend fun conflictDetection(`value`: Output<String>) {
        this.conflictDetection = value
    }

    /**
     * @param value Conflict Resolution strategy to perform in the event of a conflict. Valid values are `NONE`, `OPTIMISTIC_CONCURRENCY`, `AUTOMERGE`, and `LAMBDA`.
     */
    @JvmName("oxlekeaxvnpdyaxp")
    public suspend fun conflictHandler(`value`: Output<String>) {
        this.conflictHandler = value
    }

    /**
     * @param value Lambda Conflict Handler Config when configuring `LAMBDA` as the Conflict Handler. See Lambda Conflict Handler Config.
     */
    @JvmName("cepdhlwqhyrypdxb")
    public suspend
    fun lambdaConflictHandlerConfig(`value`: Output<FunctionSyncConfigLambdaConflictHandlerConfigArgs>) {
        this.lambdaConflictHandlerConfig = value
    }

    /**
     * @param value Conflict Detection strategy to use. Valid values are `NONE` and `VERSION`.
     */
    @JvmName("lglmvqjeuduajmnw")
    public suspend fun conflictDetection(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conflictDetection = mapped
    }

    /**
     * @param value Conflict Resolution strategy to perform in the event of a conflict. Valid values are `NONE`, `OPTIMISTIC_CONCURRENCY`, `AUTOMERGE`, and `LAMBDA`.
     */
    @JvmName("viputprvsungslge")
    public suspend fun conflictHandler(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conflictHandler = mapped
    }

    /**
     * @param value Lambda Conflict Handler Config when configuring `LAMBDA` as the Conflict Handler. See Lambda Conflict Handler Config.
     */
    @JvmName("vyqcajvmtfootmyn")
    public suspend
    fun lambdaConflictHandlerConfig(`value`: FunctionSyncConfigLambdaConflictHandlerConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdaConflictHandlerConfig = mapped
    }

    /**
     * @param argument Lambda Conflict Handler Config when configuring `LAMBDA` as the Conflict Handler. See Lambda Conflict Handler Config.
     */
    @JvmName("lvknhjkkqxtdhrom")
    public suspend
    fun lambdaConflictHandlerConfig(argument: suspend FunctionSyncConfigLambdaConflictHandlerConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FunctionSyncConfigLambdaConflictHandlerConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.lambdaConflictHandlerConfig = mapped
    }

    internal fun build(): FunctionSyncConfigArgs = FunctionSyncConfigArgs(
        conflictDetection = conflictDetection,
        conflictHandler = conflictHandler,
        lambdaConflictHandlerConfig = lambdaConflictHandlerConfig,
    )
}
