@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.inputs

import com.pulumi.aws.appsync.inputs.GraphQLApiAdditionalAuthenticationProviderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property authenticationType Authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
 * @property lambdaAuthorizerConfig Nested argument containing Lambda authorizer configuration. Defined below.
 * @property openidConnectConfig Nested argument containing OpenID Connect configuration. Defined below.
 * @property userPoolConfig Amazon Cognito User Pool configuration. Defined below.
 */
public data class GraphQLApiAdditionalAuthenticationProviderArgs(
    public val authenticationType: Output<String>,
    public val lambdaAuthorizerConfig:
    Output<GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgs>? = null,
    public val openidConnectConfig:
    Output<GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfigArgs>? = null,
    public val userPoolConfig: Output<GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.appsync.inputs.GraphQLApiAdditionalAuthenticationProviderArgs> {
    override fun toJava():
        com.pulumi.aws.appsync.inputs.GraphQLApiAdditionalAuthenticationProviderArgs =
        com.pulumi.aws.appsync.inputs.GraphQLApiAdditionalAuthenticationProviderArgs.builder()
            .authenticationType(authenticationType.applyValue({ args0 -> args0 }))
            .lambdaAuthorizerConfig(
                lambdaAuthorizerConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .openidConnectConfig(
                openidConnectConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .userPoolConfig(
                userPoolConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [GraphQLApiAdditionalAuthenticationProviderArgs].
 */
@PulumiTagMarker
public class GraphQLApiAdditionalAuthenticationProviderArgsBuilder internal constructor() {
    private var authenticationType: Output<String>? = null

    private var lambdaAuthorizerConfig:
        Output<GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgs>? = null

    private var openidConnectConfig:
        Output<GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfigArgs>? = null

    private var userPoolConfig: Output<GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs>? =
        null

    /**
     * @param value Authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
     */
    @JvmName("bgllyldklbutbfgk")
    public suspend fun authenticationType(`value`: Output<String>) {
        this.authenticationType = value
    }

    /**
     * @param value Nested argument containing Lambda authorizer configuration. Defined below.
     */
    @JvmName("jncdvcyxhvbtfxyl")
    public suspend
    fun lambdaAuthorizerConfig(`value`: Output<GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgs>) {
        this.lambdaAuthorizerConfig = value
    }

    /**
     * @param value Nested argument containing OpenID Connect configuration. Defined below.
     */
    @JvmName("sjgjkiprbiqjjnal")
    public suspend
    fun openidConnectConfig(`value`: Output<GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfigArgs>) {
        this.openidConnectConfig = value
    }

    /**
     * @param value Amazon Cognito User Pool configuration. Defined below.
     */
    @JvmName("vguahgkodchscdiq")
    public suspend
    fun userPoolConfig(`value`: Output<GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs>) {
        this.userPoolConfig = value
    }

    /**
     * @param value Authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
     */
    @JvmName("lhlfrbktoujvleev")
    public suspend fun authenticationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Nested argument containing Lambda authorizer configuration. Defined below.
     */
    @JvmName("jjcaafpdqsyukicl")
    public suspend
    fun lambdaAuthorizerConfig(`value`: GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdaAuthorizerConfig = mapped
    }

    /**
     * @param argument Nested argument containing Lambda authorizer configuration. Defined below.
     */
    @JvmName("peansutkvytmuuec")
    public suspend
    fun lambdaAuthorizerConfig(argument: suspend GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.lambdaAuthorizerConfig = mapped
    }

    /**
     * @param value Nested argument containing OpenID Connect configuration. Defined below.
     */
    @JvmName("jmyakbdustirbqde")
    public suspend
    fun openidConnectConfig(`value`: GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.openidConnectConfig = mapped
    }

    /**
     * @param argument Nested argument containing OpenID Connect configuration. Defined below.
     */
    @JvmName("gdlgeggaoubmerba")
    public suspend
    fun openidConnectConfig(argument: suspend GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.openidConnectConfig = mapped
    }

    /**
     * @param value Amazon Cognito User Pool configuration. Defined below.
     */
    @JvmName("oeenhmrbxarfhdyf")
    public suspend
    fun userPoolConfig(`value`: GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userPoolConfig = mapped
    }

    /**
     * @param argument Amazon Cognito User Pool configuration. Defined below.
     */
    @JvmName("bickckrtxsnegyhx")
    public suspend
    fun userPoolConfig(argument: suspend GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.userPoolConfig = mapped
    }

    internal fun build(): GraphQLApiAdditionalAuthenticationProviderArgs =
        GraphQLApiAdditionalAuthenticationProviderArgs(
            authenticationType = authenticationType ?: throw PulumiNullFieldException("authenticationType"),
            lambdaAuthorizerConfig = lambdaAuthorizerConfig,
            openidConnectConfig = openidConnectConfig,
            userPoolConfig = userPoolConfig,
        )
}
