@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.inputs

import com.pulumi.aws.appsync.inputs.GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authorizerResultTtlInSeconds Number of seconds a response should be cached for. The default is 5 minutes (300 seconds). The Lambda function can override this by returning a `ttlOverride` key in its response. A value of 0 disables caching of responses. Minimum value of 0. Maximum value of 3600.
 * @property authorizerUri ARN of the Lambda function to be called for authorization. Note: This Lambda function must have a resource-based policy assigned to it, to allow `lambda:InvokeFunction` from service principal `appsync.amazonaws.com`.
 * @property identityValidationExpression Regular expression for validation of tokens before the Lambda function is called.
 */
public data class GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgs(
    public val authorizerResultTtlInSeconds: Output<Int>? = null,
    public val authorizerUri: Output<String>,
    public val identityValidationExpression: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appsync.inputs.GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgs> {
    override fun toJava():
        com.pulumi.aws.appsync.inputs.GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgs =
        com.pulumi.aws.appsync.inputs.GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgs.builder()
            .authorizerResultTtlInSeconds(authorizerResultTtlInSeconds?.applyValue({ args0 -> args0 }))
            .authorizerUri(authorizerUri.applyValue({ args0 -> args0 }))
            .identityValidationExpression(identityValidationExpression?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgs].
 */
@PulumiTagMarker
public class GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgsBuilder internal
constructor() {
    private var authorizerResultTtlInSeconds: Output<Int>? = null

    private var authorizerUri: Output<String>? = null

    private var identityValidationExpression: Output<String>? = null

    /**
     * @param value Number of seconds a response should be cached for. The default is 5 minutes (300 seconds). The Lambda function can override this by returning a `ttlOverride` key in its response. A value of 0 disables caching of responses. Minimum value of 0. Maximum value of 3600.
     */
    @JvmName("xrnvktrknqipflul")
    public suspend fun authorizerResultTtlInSeconds(`value`: Output<Int>) {
        this.authorizerResultTtlInSeconds = value
    }

    /**
     * @param value ARN of the Lambda function to be called for authorization. Note: This Lambda function must have a resource-based policy assigned to it, to allow `lambda:InvokeFunction` from service principal `appsync.amazonaws.com`.
     */
    @JvmName("icjelooaaddyaeil")
    public suspend fun authorizerUri(`value`: Output<String>) {
        this.authorizerUri = value
    }

    /**
     * @param value Regular expression for validation of tokens before the Lambda function is called.
     */
    @JvmName("atjqjwaibdlihqid")
    public suspend fun identityValidationExpression(`value`: Output<String>) {
        this.identityValidationExpression = value
    }

    /**
     * @param value Number of seconds a response should be cached for. The default is 5 minutes (300 seconds). The Lambda function can override this by returning a `ttlOverride` key in its response. A value of 0 disables caching of responses. Minimum value of 0. Maximum value of 3600.
     */
    @JvmName("chvkkhhgpkmfehpa")
    public suspend fun authorizerResultTtlInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizerResultTtlInSeconds = mapped
    }

    /**
     * @param value ARN of the Lambda function to be called for authorization. Note: This Lambda function must have a resource-based policy assigned to it, to allow `lambda:InvokeFunction` from service principal `appsync.amazonaws.com`.
     */
    @JvmName("dgxfcponhrmuhkap")
    public suspend fun authorizerUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizerUri = mapped
    }

    /**
     * @param value Regular expression for validation of tokens before the Lambda function is called.
     */
    @JvmName("tdxaklglrketkltq")
    public suspend fun identityValidationExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityValidationExpression = mapped
    }

    internal fun build(): GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgs =
        GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgs(
            authorizerResultTtlInSeconds = authorizerResultTtlInSeconds,
            authorizerUri = authorizerUri ?: throw PulumiNullFieldException("authorizerUri"),
            identityValidationExpression = identityValidationExpression,
        )
}
