@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.inputs

import com.pulumi.aws.appsync.inputs.GraphQLApiLogConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cloudwatchLogsRoleArn Amazon Resource Name of the service role that AWS AppSync will assume to publish to Amazon CloudWatch logs in your account.
 * @property excludeVerboseContent Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging  level. Valid values: `true`, `false`. Default value: `false`
 * @property fieldLogLevel Field logging level. Valid values: `ALL`, `ERROR`, `NONE`.
 */
public data class GraphQLApiLogConfigArgs(
    public val cloudwatchLogsRoleArn: Output<String>,
    public val excludeVerboseContent: Output<Boolean>? = null,
    public val fieldLogLevel: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appsync.inputs.GraphQLApiLogConfigArgs> {
    override fun toJava(): com.pulumi.aws.appsync.inputs.GraphQLApiLogConfigArgs =
        com.pulumi.aws.appsync.inputs.GraphQLApiLogConfigArgs.builder()
            .cloudwatchLogsRoleArn(cloudwatchLogsRoleArn.applyValue({ args0 -> args0 }))
            .excludeVerboseContent(excludeVerboseContent?.applyValue({ args0 -> args0 }))
            .fieldLogLevel(fieldLogLevel.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GraphQLApiLogConfigArgs].
 */
@PulumiTagMarker
public class GraphQLApiLogConfigArgsBuilder internal constructor() {
    private var cloudwatchLogsRoleArn: Output<String>? = null

    private var excludeVerboseContent: Output<Boolean>? = null

    private var fieldLogLevel: Output<String>? = null

    /**
     * @param value Amazon Resource Name of the service role that AWS AppSync will assume to publish to Amazon CloudWatch logs in your account.
     */
    @JvmName("aartwurfysdxrbni")
    public suspend fun cloudwatchLogsRoleArn(`value`: Output<String>) {
        this.cloudwatchLogsRoleArn = value
    }

    /**
     * @param value Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging  level. Valid values: `true`, `false`. Default value: `false`
     */
    @JvmName("wlsedbgojgrjihvp")
    public suspend fun excludeVerboseContent(`value`: Output<Boolean>) {
        this.excludeVerboseContent = value
    }

    /**
     * @param value Field logging level. Valid values: `ALL`, `ERROR`, `NONE`.
     */
    @JvmName("xindotydmccdcsyh")
    public suspend fun fieldLogLevel(`value`: Output<String>) {
        this.fieldLogLevel = value
    }

    /**
     * @param value Amazon Resource Name of the service role that AWS AppSync will assume to publish to Amazon CloudWatch logs in your account.
     */
    @JvmName("ikxekrisxfefbipp")
    public suspend fun cloudwatchLogsRoleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cloudwatchLogsRoleArn = mapped
    }

    /**
     * @param value Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging  level. Valid values: `true`, `false`. Default value: `false`
     */
    @JvmName("yoagkjldqnvepukq")
    public suspend fun excludeVerboseContent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludeVerboseContent = mapped
    }

    /**
     * @param value Field logging level. Valid values: `ALL`, `ERROR`, `NONE`.
     */
    @JvmName("bafuvuvankmeaopg")
    public suspend fun fieldLogLevel(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldLogLevel = mapped
    }

    internal fun build(): GraphQLApiLogConfigArgs = GraphQLApiLogConfigArgs(
        cloudwatchLogsRoleArn = cloudwatchLogsRoleArn ?: throw
            PulumiNullFieldException("cloudwatchLogsRoleArn"),
        excludeVerboseContent = excludeVerboseContent,
        fieldLogLevel = fieldLogLevel ?: throw PulumiNullFieldException("fieldLogLevel"),
    )
}
