@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authorizationType Authorization type that the HTTP endpoint requires. Default values is `AWS_IAM`.
 * @property awsIamConfig Identity and Access Management (IAM) settings. See AWS IAM Config.
 */
public data class DataSourceHttpConfigAuthorizationConfig(
    public val authorizationType: String? = null,
    public val awsIamConfig: DataSourceHttpConfigAuthorizationConfigAwsIamConfig? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appsync.outputs.DataSourceHttpConfigAuthorizationConfig):
            DataSourceHttpConfigAuthorizationConfig = DataSourceHttpConfigAuthorizationConfig(
            authorizationType = javaType.authorizationType().map({ args0 -> args0 }).orElse(null),
            awsIamConfig = javaType.awsIamConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appsync.kotlin.outputs.DataSourceHttpConfigAuthorizationConfigAwsIamConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
