@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property signingRegion Signing Amazon Web Services Region for IAM authorization.
 * @property signingServiceName Signing service name for IAM authorization.
 */
public data class DataSourceHttpConfigAuthorizationConfigAwsIamConfig(
    public val signingRegion: String? = null,
    public val signingServiceName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appsync.outputs.DataSourceHttpConfigAuthorizationConfigAwsIamConfig):
            DataSourceHttpConfigAuthorizationConfigAwsIamConfig =
            DataSourceHttpConfigAuthorizationConfigAwsIamConfig(
                signingRegion = javaType.signingRegion().map({ args0 -> args0 }).orElse(null),
                signingServiceName = javaType.signingServiceName().map({ args0 -> args0 }).orElse(null),
            )
    }
}
