@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authenticationType Authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
 * @property lambdaAuthorizerConfig Nested argument containing Lambda authorizer configuration. Defined below.
 * @property openidConnectConfig Nested argument containing OpenID Connect configuration. Defined below.
 * @property userPoolConfig Amazon Cognito User Pool configuration. Defined below.
 */
public data class GraphQLApiAdditionalAuthenticationProvider(
    public val authenticationType: String,
    public val lambdaAuthorizerConfig:
    GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfig? = null,
    public val openidConnectConfig: GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig? =
        null,
    public val userPoolConfig: GraphQLApiAdditionalAuthenticationProviderUserPoolConfig? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appsync.outputs.GraphQLApiAdditionalAuthenticationProvider):
            GraphQLApiAdditionalAuthenticationProvider = GraphQLApiAdditionalAuthenticationProvider(
            authenticationType = javaType.authenticationType(),
            lambdaAuthorizerConfig = javaType.lambdaAuthorizerConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appsync.kotlin.outputs.GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            openidConnectConfig = javaType.openidConnectConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appsync.kotlin.outputs.GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            userPoolConfig = javaType.userPoolConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appsync.kotlin.outputs.GraphQLApiAdditionalAuthenticationProviderUserPoolConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
