@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property appIdClientRegex Regular expression for validating the incoming Amazon Cognito User Pool app client ID.
 * @property awsRegion AWS region in which the user pool was created.
 * @property userPoolId User pool ID.
 */
public data class GraphQLApiAdditionalAuthenticationProviderUserPoolConfig(
    public val appIdClientRegex: String? = null,
    public val awsRegion: String? = null,
    public val userPoolId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appsync.outputs.GraphQLApiAdditionalAuthenticationProviderUserPoolConfig):
            GraphQLApiAdditionalAuthenticationProviderUserPoolConfig =
            GraphQLApiAdditionalAuthenticationProviderUserPoolConfig(
                appIdClientRegex = javaType.appIdClientRegex().map({ args0 -> args0 }).orElse(null),
                awsRegion = javaType.awsRegion().map({ args0 -> args0 }).orElse(null),
                userPoolId = javaType.userPoolId(),
            )
    }
}
